/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import org.apache.mina.common.ByteBuffer;

public class RtmpRequestMessage {
    public static final int REQTYPE_UNKNOWN = 0;
    public static final int REQTYPE_OPEN = 1;
    public static final int REQTYPE_SEND = 2;
    public static final int REQTYPE_IDLE = 3;
    public static final int REQTYPE_CLOSE = 4;
    public static final int REQTYPE_FCS = 5;
    public static final int REQTYPE_RTSP = 6;
    public static final String[] REQUSERAGENT_FLASH = new String[]{"Shockwave Flash", "CFNetwork", "MacNetwork/1.0 (Macintosh)"};
    private ByteBuffer body = null;
    private int protocol = 3;
    private boolean isSSL = false;
    private String vhostName = "_defaultVHost_";
    private RtmpSessionInfo sessionInfo = null;
    private long lastReadTime = 0L;
    private int type = 2;
    private int clientId = -1;
    private int sequence = -1;
    private int contentLength = 0;
    private int headerLength = 0;
    private String userAgent = "unknown";
    private HostPort hostPort = null;
    private IVHost vhost = null;
    private String fcsCommand = null;
    private String protocolStr = "HTTP/1.1";
    private String contentType = "";
    private String accept = "";
    private String method = "";
    private IHTTPStreamerAdapter httpStreamerAdapter = null;
    private String path = "";
    private long createTimecode = -1L;

    public RtmpRequestMessage() {
        this.init();
    }

    public RtmpRequestMessage(RtmpSessionInfo rtmpSessionInfo, String string, int n, boolean bl) {
        this.sessionInfo = rtmpSessionInfo;
        this.vhostName = string;
        this.protocol = n;
        this.isSSL = bl;
        this.init();
    }

    private void init() {
        this.createTimecode = System.currentTimeMillis();
    }

    public RtmpRequestMessage clone(byte[] byArray, int n, int n2) {
        RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage();
        rtmpRequestMessage.body = ByteBuffer.wrap((byte[])byArray, (int)n, (int)n2);
        rtmpRequestMessage.protocol = this.protocol;
        rtmpRequestMessage.isSSL = this.isSSL;
        rtmpRequestMessage.vhostName = this.vhostName;
        rtmpRequestMessage.sessionInfo = this.sessionInfo;
        rtmpRequestMessage.lastReadTime = this.lastReadTime;
        rtmpRequestMessage.type = this.type;
        rtmpRequestMessage.clientId = this.clientId;
        rtmpRequestMessage.sequence = this.sequence;
        rtmpRequestMessage.contentLength = this.contentLength;
        rtmpRequestMessage.headerLength = this.headerLength;
        rtmpRequestMessage.userAgent = this.userAgent;
        rtmpRequestMessage.hostPort = this.hostPort;
        rtmpRequestMessage.vhost = this.vhost;
        rtmpRequestMessage.fcsCommand = this.fcsCommand;
        rtmpRequestMessage.protocolStr = this.protocolStr;
        rtmpRequestMessage.contentType = this.contentType;
        rtmpRequestMessage.accept = this.accept;
        rtmpRequestMessage.method = this.method;
        rtmpRequestMessage.httpStreamerAdapter = this.httpStreamerAdapter;
        rtmpRequestMessage.path = this.path;
        rtmpRequestMessage.createTimecode = this.createTimecode;
        return rtmpRequestMessage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{RtmpRequestMessage: ");
        stringBuffer.append("method: \"" + this.method + "\", ");
        stringBuffer.append("path: \"" + this.path + "\", ");
        stringBuffer.append("protocolStr: \"" + this.protocolStr + "\", ");
        stringBuffer.append("contentType: \"" + this.contentType + "\", ");
        stringBuffer.append("accept: \"" + this.accept + "\", ");
        stringBuffer.append("protocol: " + this.protocol + ", ");
        stringBuffer.append("vhostName: \"" + this.vhostName + "\", ");
        stringBuffer.append("userAgent: \"" + this.userAgent + "\", ");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public ByteBuffer getBody() {
        return this.body;
    }

    public void setBody(ByteBuffer byteBuffer) {
        this.body = byteBuffer;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public String getVHostName() {
        return this.vhostName;
    }

    public void setVHostName(String string) {
        this.vhostName = string;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean bl) {
        this.isSSL = bl;
    }

    public RtmpSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSessionInfo(RtmpSessionInfo rtmpSessionInfo) {
        this.sessionInfo = rtmpSessionInfo;
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public void setLastReadTime(long l) {
        this.lastReadTime = l;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void decodeHeader(IVHost iVHost, String string, String[] stringArray, HostPort hostPort, String string2) {
        IHTTPStreamerAdapter iHTTPStreamerAdapter;
        String string3;
        this.type = 2;
        if (this.protocol == 32 && string != null) {
            if (stringArray == null) {
                stringArray = REQUSERAGENT_FLASH;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) < 0) continue;
                this.protocol = 3;
                break;
            }
            if (this.protocol == 3 && string2 != null) {
                String[] stringArray2 = string2.split("/");
                if (stringArray2 == null) {
                    this.protocol = 32;
                } else {
                    string3 = stringArray2[0];
                    if (!(string3.equals("idle") || string3.equals("send") || string3.equals("open") || string3.equals("close") || string3.equals("fcs"))) {
                        this.protocol = 32;
                    }
                }
            }
        }
        if (this.protocol == 32) {
            IHTTPStreamerAdapter iHTTPStreamerAdapter2;
            if (this.protocolStr.startsWith("RTSP")) {
                this.protocol = 34;
            } else if (hostPort != null && iVHost != null && (iHTTPStreamerAdapter2 = HTTPStreamerUtils.pathToAdapter(iVHost, hostPort, string2)) != null) {
                this.protocol = 37;
                this.httpStreamerAdapter = iHTTPStreamerAdapter2;
            }
        } else if (this.protocol == 37 && hostPort != null && iVHost != null && (iHTTPStreamerAdapter = HTTPStreamerUtils.pathToAdapter(iVHost, hostPort, string2)) != null) {
            this.protocol = 37;
            this.httpStreamerAdapter = iHTTPStreamerAdapter;
        }
        if (this.protocol == 3) {
            this.type = 0;
            String[] stringArray3 = string2.split("/");
            string3 = stringArray3[0];
            if (stringArray3.length == 3) {
                this.clientId = Integer.parseInt(stringArray3[1]);
                this.sequence = Integer.parseInt(stringArray3[2]);
            }
            if (string3.equals("idle")) {
                this.type = 3;
            } else if (string3.equals("send")) {
                this.type = 2;
            } else if (string3.equals("open")) {
                this.type = 1;
            } else if (string3.equals("close")) {
                this.type = 4;
            } else if (string3.equals("fcs")) {
                this.type = 5;
                this.fcsCommand = "unknown";
                if (stringArray3.length >= 2) {
                    this.fcsCommand = stringArray3[1];
                }
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int n) {
        this.clientId = n;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int n) {
        this.sequence = n;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int n) {
        this.headerLength = n;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(HostPort hostPort) {
        this.hostPort = hostPort;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    public void setVHost(IVHost iVHost) {
        this.vhost = iVHost;
    }

    public String getFcsCommand() {
        return this.fcsCommand;
    }

    public void setFcsCommand(String string) {
        this.fcsCommand = string;
    }

    public String getProtocolStr() {
        return this.protocolStr;
    }

    public void setProtocolStr(String string) {
        this.protocolStr = string;
    }

    public boolean isHTTP10() {
        return this.protocolStr == null ? false : this.protocolStr.equals("HTTP/1.0");
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public IHTTPStreamerAdapter getHTTPStreamerAdapter() {
        return this.httpStreamerAdapter;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String string) {
        this.accept = string;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public long getCreateTime() {
        return this.createTimecode;
    }
}

