/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream;

import com.wowza.util.AMFUtils;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import com.wowza.wms.stream.IMediaStreamActionNotify2;
import com.wowza.wms.stream.IMediaStreamCallback;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MediaStream
implements IMediaStream {
    public static final String BASE_STREAM_EXT = "flv";
    public static final String MP3_STREAM_EXT = "mp3";
    public static final String ID3_STREAM_EXT = "id3";
    public static final String MP4_STREAM_EXT = "mp4";
    public static final String SMIL_STREAM_EXT = "smil";
    public static final int SEND_CONTROL0 = 0;
    public static final int SEND_CONTROL1 = 1;
    public static final int SEND_CONTROL3 = 3;
    public static final int SEND_CONTROL4 = 4;
    public static final String STREAM_DEFAULTNAME = "";
    protected int src = 0;
    protected String name = "";
    protected boolean isVideoBase = false;
    protected boolean isAudioBase = false;
    protected boolean isDataBase = false;
    protected int audioSize = 0;
    protected int videoSize = 0;
    protected int dataSize = 0;
    protected long audioTC = 0L;
    protected long videoTC = 0L;
    protected long dataTC = 0L;
    protected long baseTC = 0L;
    protected int dataType = 18;
    protected MediaStreamMap parent = null;
    protected IClient client = null;
    protected INetConnection netConnection = null;
    protected boolean isRecord = false;
    protected boolean isAppend = false;
    protected boolean isPlay = false;
    protected boolean isClustered = false;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected String ext = "flv";
    protected int playTransition = 0;
    protected boolean isPlaying = true;
    protected boolean isOpen = false;
    protected int bufferTime = 0;
    protected IMediaStreamPlay player = null;
    protected WMSProperties properties = new WMSProperties();
    protected String streamType = "default";
    protected FastPlaySettings fastPlaySettings = null;
    protected boolean receiveAudio = true;
    protected boolean receiveVideo = true;
    protected int receiveVideoFPS = -1;
    protected Map callbacks = new HashMap();
    protected List actionListeners = new ArrayList();
    protected IOPerformanceCounter mediaIOPerformance = new IOPerformanceCounter();
    protected int audioBytes = 0;
    protected int videoBytes = 0;
    protected int dataBytes = 0;
    protected String queryStr = "";
    protected ElapsedTimer elapsedTime = new ElapsedTimer();
    protected boolean sendPlayStopLogEvent = false;
    protected boolean sendRecordStopLogEvent = false;
    protected boolean sendPublishStopLogEvent = false;
    protected IMediaStreamMetaDataProvider metaDataProvider = null;
    protected int headerSize = 0;
    protected RTPStream rtpStream = null;
    protected IHTTPStreamerSession httpStreamerSession = null;
    protected String liveStreamPacketizerList = null;
    protected String liveStreamPacketizer = null;
    protected String liveStreamRepeater = null;
    protected List<SendDirectMessage> sendDirectMessages = null;
    protected Object sendDirectLock = new Object();
    protected boolean isMediaCasterPlay = true;
    protected boolean mergeOnMetadata = true;

    protected void reset() {
    }

    @Override
    public void init(MediaStreamMap mediaStreamMap, int n, WMSProperties wMSProperties) {
        this.parent = mediaStreamMap;
        this.src = n;
        WMSProperties.cloneProperties(wMSProperties, this.properties);
        IApplicationInstance iApplicationInstance = mediaStreamMap.getAppInstance();
        if (iApplicationInstance != null) {
            WMSProperties.cloneProperties(iApplicationInstance.getStreamProperties(), this.properties);
        }
        this.isAppend = this.properties.getPropertyBoolean("appendFile", this.isAppend);
    }

    @Override
    public int getBufferTime() {
        return this.bufferTime;
    }

    @Override
    public void setBufferTime(int n) {
        int n2 = this.bufferTime;
        this.bufferTime = n;
        if (this.player != null) {
            this.player.setBufferTime(n);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public void setIsPlaying(boolean bl) {
        this.isPlaying = bl;
    }

    @Override
    public int getAudioSize() {
        return this.audioSize;
    }

    @Override
    public int getVideoSize() {
        return this.videoSize;
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    @Override
    public void startAudioPacket() {
    }

    @Override
    public void startVideoPacket() {
    }

    @Override
    public void startDataPacket() {
    }

    @Override
    public void setAudioSize(int n) {
        this.audioSize = n;
    }

    @Override
    public void setVideoSize(int n) {
        this.videoSize = n;
    }

    @Override
    public void setDataSize(int n) {
        this.dataSize = n;
    }

    @Override
    public int getSrc() {
        return this.src;
    }

    @Override
    public void setSrc(int n) {
        this.src = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.setName(string, null, BASE_STREAM_EXT, STREAM_DEFAULTNAME, -2.0, -1.0, 1);
    }

    @Override
    public void setName(String string, String string2) {
        this.setName(string, null, string2, STREAM_DEFAULTNAME, -2.0, -1.0, 1);
    }

    public void setJustName(String string) {
        this.name = string;
    }

    @Override
    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        if (this.player != null) {
            this.player.switchName(string, string2, string3, string4, d, d2, n);
        }
    }

    @Override
    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        if (this.player != null) {
            this.player.stopName(string, string2, string3, string4, d, d2, n);
        }
    }

    @Override
    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        if (!this.isPlay) {
            this.parent.setStreamName(this, string);
        }
        this.name = string;
        this.ext = string3;
        this.playStart = d;
        this.playLen = d2;
        this.playTransition = n;
        this.queryStr = string4;
        if (this.player != null) {
            this.player.setName(string, string2, string3, string4, d, d2, n);
        }
    }

    @Override
    public void shutdown() {
        IApplicationInstance iApplicationInstance;
        if (this.parent != null && (iApplicationInstance = this.parent.getAppInstance()) != null) {
            iApplicationInstance.removePlayStreamByName(this);
        }
        if (this.player != null) {
            this.player.shutdown();
        }
        this.player = null;
        if (!this.isPlay) {
            this.parent.clearStreamName(this.name, this);
        }
    }

    @Override
    public long getAudioTC() {
        return this.audioTC;
    }

    @Override
    public void setAudioTC(long l) {
        this.audioTC = l;
    }

    @Override
    public void setAudioTC(long l, boolean bl) {
        this.audioTC = bl ? l : (this.audioTC += l);
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(int n) {
        this.dataType = n;
    }

    @Override
    public long getDataTC() {
        return this.dataTC;
    }

    @Override
    public void setDataTC(long l, boolean bl) {
        this.dataTC = bl ? l : (this.dataTC += l);
    }

    @Override
    public void setDataTC(long l) {
        this.dataTC = l;
    }

    @Override
    public long getVideoTC() {
        return this.videoTC;
    }

    @Override
    public void setVideoTC(long l, boolean bl) {
        this.videoTC = bl ? l : (this.videoTC += l);
    }

    @Override
    public void setVideoTC(long l) {
        this.videoTC = l;
    }

    @Override
    public boolean isRecord() {
        return this.isRecord;
    }

    @Override
    public void setRecord(boolean bl) {
        this.isRecord = bl;
    }

    @Override
    public boolean isPlay() {
        return this.isPlay;
    }

    @Override
    public void setPlay(boolean bl) {
        this.isPlay = bl;
    }

    @Override
    public boolean idle() {
        return true;
    }

    @Override
    public IClient getClient() {
        return this.client;
    }

    @Override
    public int getClientId() {
        return this.client == null ? -1 : this.client.getClientId();
    }

    @Override
    public void setClient(IClient iClient) {
        this.client = iClient;
    }

    @Override
    public MediaStreamMap getStreams() {
        return this.parent;
    }

    @Override
    public void packetComplete() {
    }

    @Override
    public int sendPlayReset(String string) {
        return this.sendPlayReset(null, string);
    }

    @Override
    public int sendPlayReset(OutputStream outputStream, String string) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Reset"));
        aMFDataObj.put("description", new AMFDataItem("Playing and resetting " + string + "."));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        return n;
    }

    @Override
    public byte[] getBurstStartStop(boolean bl) {
        byte by = (byte)(bl ? 32 : 31);
        byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, by, (byte)(0xFF & this.src >> 24), (byte)(0xFF & this.src >> 16), (byte)(0xFF & this.src >> 8), (byte)(0xFF & this.src)};
        return byArray;
    }

    @Override
    public int sendControlBytes(int n, OutputStream outputStream) {
        Object object;
        Object object2;
        Object object3 = null;
        int n2 = 0;
        switch (n) {
            case 0: {
                object3 = object2 = (Object)new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, (byte)(0xFF & this.src >> 24), (byte)(0xFF & this.src >> 16), (byte)(0xFF & this.src >> 8), (byte)(0xFF & this.src)};
                break;
            }
            case 1: {
                object3 = object = (Object)new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 1, (byte)(0xFF & this.src >> 24), (byte)(0xFF & this.src >> 16), (byte)(0xFF & this.src >> 8), (byte)(0xFF & this.src)};
                break;
            }
            case 4: {
                byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 4, (byte)(0xFF & this.src >> 24), (byte)(0xFF & this.src >> 16), (byte)(0xFF & this.src >> 8), (byte)(0xFF & this.src)};
                object3 = byArray;
                break;
            }
            case 3: {
                byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 10, 4, 0, 0, 0, 0, 0, 3, (byte)(0xFF & this.src >> 24), (byte)(0xFF & this.src >> 16), (byte)(0xFF & this.src >> 8), (byte)(0xFF & this.src), 0, 0, 0, 100};
                object3 = byArray;
            }
        }
        if (object3 != null) {
            object2 = new ResponseFunction(this.getClient());
            ((ResponseFunction)object2).addBytes((byte[])object3);
            if (outputStream == null) {
                object = this.getClient();
                if (object != null) {
                    object.getRespFunctions().add((ResponseFunction)object2);
                }
            } else {
                n2 += ((ResponseFunction)object2).write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n2;
    }

    @Override
    public int sendStreamNotFound(String string) {
        return this.sendStreamNotFound(null, string);
    }

    @Override
    public int sendStreamNotFound(OutputStream outputStream, String string) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("error"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.StreamNotFound"));
        aMFDataObj.put("description", new AMFDataItem("Failed to play " + string + "; stream not found."));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        aMFDataObj.put("details", new AMFDataItem(string));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
        }
        return n;
    }

    @Override
    public int sendPlayStop(long l, String string) {
        return this.sendPlayStop(null, l, string);
    }

    @Override
    public int sendPlayStop(OutputStream outputStream, long l, String string) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        n += this.sendControlBytes(1, outputStream);
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        if (l >= 0L) {
            responseFunction.setTimecode(l);
        }
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Stop"));
        aMFDataObj.put("description", new AMFDataItem("Stopped playing " + string + "."));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        aMFDataObj.put("reason", new AMFDataItem(STREAM_DEFAULTNAME));
        aMFDataObj.put("details", new AMFDataItem(string));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, l >= 0L, ((Client)this.client).getSendChunkSize());
        }
        return n;
    }

    private AMFDataObj getNetStreamPlayStart(String string) {
        double d = this.getClient().getClientId();
        AMFDataObj aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Start"));
        aMFDataObj.put("description", new AMFDataItem("Started playing " + string + "."));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        boolean bl = this.fastPlaySettings != null;
        double d2 = this.fastPlaySettings == null ? 1.0 : this.fastPlaySettings.getMultiplier();
        long l = this.fastPlaySettings == null ? 0L : this.fastPlaySettings.getStartTC() + this.fastPlaySettings.getStartTCOffset();
        int n = this.fastPlaySettings == null ? 1 : this.fastPlaySettings.getDirection();
        aMFDataObj.put("isFastPlay", new AMFDataItem(bl));
        if (bl) {
            aMFDataObj.put("fastPlayMultiplier", new AMFDataItem(d2));
            aMFDataObj.put("fastPlayOffset", new AMFDataItem(l));
            aMFDataObj.put("fastPlayDirection", new AMFDataItem(n));
        }
        return aMFDataObj;
    }

    @Override
    public int sendPlaySeek(long l, long l2, String string) {
        return this.sendPlaySeek(null, l, l2, string, null);
    }

    @Override
    public int sendPlaySeek(OutputStream outputStream, long l, long l2, String string) {
        return this.sendPlaySeek(outputStream, l, l2, string, null);
    }

    @Override
    public int sendPlaySeek(OutputStream outputStream, long l, long l2, String string, List<Integer> list) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        n += this.sendControlBytes(1, outputStream);
        n += this.sendControlBytes(4, outputStream);
        n += this.sendControlBytes(0, outputStream);
        if (list != null) {
            this.sendOnStatusSeekTypes(list, outputStream, l2, l);
        } else {
            responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
            responseFunction.createDefaultMessage("onStatus", 0.0);
            responseFunction.setSrc(this.src);
            responseFunction.setTimecode(l2);
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Seek.Notify"));
            aMFDataObj.put("description", new AMFDataItem("Seeking " + l + " (Stream ID: " + this.src + ")."));
            aMFDataObj.put("details", new AMFDataItem(string));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
            }
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        aMFDataObj = this.getNetStreamPlayStart(string);
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = this.getSampleAccessResponse();
        if (responseFunction != null) {
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n;
    }

    @Override
    public int sendPlayStart(String string, long l) {
        return this.sendPlayStart(null, string, false, l, null);
    }

    @Override
    public int sendPlaySwitch(String string, long l) {
        return this.sendPlayStart(null, string, false, l, null);
    }

    @Override
    public int sendPlaySwitch(OutputStream outputStream, String string, boolean bl, long l) {
        return this.sendPlayStart(outputStream, string, bl, l, null);
    }

    @Override
    public int sendPlayStart(OutputStream outputStream, String string, boolean bl, long l) {
        return this.sendPlayStart(outputStream, string, bl, l, null);
    }

    @Override
    public int sendPlayStart(OutputStream outputStream, String string, boolean bl, long l, List<Integer> list) {
        return this.sendPlayStart(outputStream, string, bl, false, l, list);
    }

    @Override
    public int sendPlayStart(OutputStream outputStream, String string, boolean bl, boolean bl2, long l, List<Integer> list) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        if (bl) {
            n += this.sendControlBytes(1, outputStream);
        }
        if (!bl2) {
            n += this.sendControlBytes(4, outputStream);
        }
        if (!bl) {
            n += this.sendControlBytes(0, outputStream);
        }
        if (list != null) {
            this.sendOnStatusSeekTypes(list, outputStream, l, l);
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        aMFDataObj = this.getNetStreamPlayStart(string);
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = this.getSampleAccessResponse();
        if (responseFunction != null) {
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n;
    }

    private ResponseFunction getSampleAccessResponse() {
        boolean bl = true;
        if (this.client != null) {
            bl = this.client.isFlashVersion90115();
        }
        ResponseFunction responseFunction = null;
        if (bl) {
            boolean[] blArray = this.getAccess(this.client, this.name);
            responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
            responseFunction.createPlayStatusMessage("|RtmpSampleAccess");
            responseFunction.setSrc(this.src);
            responseFunction.setType(18);
            responseFunction.addBody(new AMFDataItem(blArray[2]));
            responseFunction.addBody(new AMFDataItem(blArray[3]));
        }
        return responseFunction;
    }

    @Override
    public int sendLivePlayStart(OutputStream outputStream, String string, long l, long l2) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        n += this.sendControlBytes(0, outputStream);
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        responseFunction.setTimecode(l);
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Reset"));
        aMFDataObj.put("description", new AMFDataItem("Playing and resetting " + string + "."));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        aMFDataObj = this.getNetStreamPlayStart(string);
        aMFDataObj.put("timecodeOffset", new AMFDataItem(l2 + "L"));
        responseFunction.addBody(aMFDataObj);
        responseFunction.setTimecode(l);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = this.getSampleAccessResponse();
        if (responseFunction != null) {
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n;
    }

    @Override
    public int sendVODPlaySwitch(OutputStream outputStream, String string, long l) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        responseFunction.setTimecode(l);
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Transition"));
        aMFDataObj.put("description", new AMFDataItem("Transitioned to " + string + "."));
        aMFDataObj.put("details", new AMFDataItem(string));
        aMFDataObj.put("reason", new AMFDataItem("NetStream.Transition.Success"));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createPlayStatusMessage("onPlayStatus");
        responseFunction.setSrc(this.src);
        aMFDataObj = this.getNetStreamPlayStart(string);
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.TransitionComplete"));
        responseFunction.addBody(aMFDataObj);
        responseFunction.setTimecode(l);
        responseFunction.setType(18);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = this.getSampleAccessResponse();
        if (responseFunction != null) {
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n;
    }

    @Override
    public int sendLivePlaySwitch(OutputStream outputStream, String string, long l) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        responseFunction.setTimecode(l);
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.Transition"));
        aMFDataObj.put("description", new AMFDataItem("Transitioned to " + string + "."));
        aMFDataObj.put("details", new AMFDataItem(string));
        aMFDataObj.put("reason", new AMFDataItem("NetStream.Transition.Success"));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createPlayStatusMessage("onPlayStatus");
        responseFunction.setSrc(this.src);
        aMFDataObj = this.getNetStreamPlayStart(string);
        aMFDataObj.put("code", new AMFDataItem("NetStream.Play.TransitionComplete"));
        responseFunction.addBody(aMFDataObj);
        responseFunction.setTimecode(l);
        responseFunction.setType(18);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = this.getSampleAccessResponse();
        if (responseFunction != null) {
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n;
    }

    @Override
    public int sendLivePlaySeek(OutputStream outputStream, String string, long l) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        n += this.sendControlBytes(0, outputStream);
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        responseFunction.setTimecode(l);
        int n2 = -1000;
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Seek.Notify"));
        aMFDataObj.put("description", new AMFDataItem("Seeking " + n2 + " (Stream ID: " + this.src + ")."));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        responseFunction.setTimecode(l);
        aMFDataObj = this.getNetStreamPlayStart(string);
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = this.getSampleAccessResponse();
        if (responseFunction != null) {
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n;
    }

    @Override
    public int sendPlayStatus(long l, int n, double d, double d2) {
        return this.sendPlayStatus(null, l, n, d, d2);
    }

    @Override
    public int sendPlayStatus(OutputStream outputStream, long l, int n, double d, double d2) {
        int n2 = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        if (n == 3 || n == 2) {
            n2 += this.sendControlBytes(1, outputStream);
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createPlayStatusMessage("onPlayStatus");
        responseFunction.setType(18);
        responseFunction.setTimecode(l);
        responseFunction.setSrc(this.src);
        String string = "NetStream.Play.Switch";
        switch (n) {
            case 1: {
                string = "NetStream.Play.Switch";
                break;
            }
            case 2: {
                string = "NetStream.Play.Complete";
                break;
            }
            case 3: {
                string = "NetStream.Play.Stop";
            }
        }
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem(string));
        aMFDataObj.put("duration", new AMFDataItem(d));
        aMFDataObj.put("bytes", new AMFDataItem(d2));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n2 += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
        }
        return n2;
    }

    @Override
    public int sendPauseNotify(long l, String string) {
        return this.sendPauseNotify(null, l, string);
    }

    @Override
    public int sendPauseNotify(OutputStream outputStream, long l, String string) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        n += this.sendControlBytes(1, outputStream);
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        aMFDataObj = new AMFDataObj();
        aMFDataObj.put("level", new AMFDataItem("status"));
        aMFDataObj.put("code", new AMFDataItem("NetStream.Pause.Notify"));
        aMFDataObj.put("description", new AMFDataItem("Pausing " + string + "."));
        aMFDataObj.put("details", new AMFDataItem(string));
        aMFDataObj.put("clientid", new AMFDataItem(d));
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
        }
        return n;
    }

    @Override
    public int sendUnpauseNotify(long l, String string) {
        return this.sendUnpauseNotify(null, l, string, null);
    }

    @Override
    public int sendUnpauseNotify(OutputStream outputStream, long l, String string) {
        return this.sendUnpauseNotify(outputStream, l, string, null);
    }

    @Override
    public int sendUnpauseNotify(OutputStream outputStream, long l, String string, List<Integer> list) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        n += this.sendControlBytes(4, outputStream);
        n += this.sendControlBytes(0, outputStream);
        if (list != null) {
            this.sendOnStatusSeekTypes(list, outputStream, l, l);
        } else {
            responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
            responseFunction.createDefaultMessage("onStatus", 0.0);
            responseFunction.setSrc(this.src);
            responseFunction.setTimecode(l);
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Unpause.Notify"));
            aMFDataObj.put("description", new AMFDataItem("Unpausing " + string + "."));
            aMFDataObj.put("details", new AMFDataItem(string));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
            }
        }
        responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
        responseFunction.createDefaultMessage("onStatus", 0.0);
        responseFunction.setSrc(this.src);
        aMFDataObj = this.getNetStreamPlayStart(string);
        responseFunction.addBody(aMFDataObj);
        if (outputStream == null) {
            responseFunctions.add(responseFunction);
        } else {
            n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
        }
        responseFunction = this.getSampleAccessResponse();
        if (responseFunction != null) {
            if (outputStream == null) {
                responseFunctions.add(responseFunction);
            } else {
                n += responseFunction.write(outputStream, ((Client)this.client).getSendChunkSize());
            }
        }
        return n;
    }

    private int sendOnStatusSeekTypes(List<Integer> list, OutputStream outputStream, long l, long l2) {
        int n = 0;
        AMFDataObj aMFDataObj = null;
        ResponseFunction responseFunction = null;
        ResponseFunctions responseFunctions = this.getClient().getRespFunctions();
        double d = this.getClient().getClientId();
        for (int n2 : list) {
            switch (n2) {
                case 1: {
                    responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
                    responseFunction.createDefaultMessage("onStatus", 0.0);
                    responseFunction.setSrc(this.src);
                    responseFunction.setTimecode(l);
                    aMFDataObj = new AMFDataObj();
                    aMFDataObj.put("level", new AMFDataItem("status"));
                    aMFDataObj.put("code", new AMFDataItem("NetStream.Seek.Notify"));
                    aMFDataObj.put("description", new AMFDataItem("Seeking " + l2 + " (Stream ID: " + this.src + ")."));
                    aMFDataObj.put("details", new AMFDataItem(this.name));
                    aMFDataObj.put("clientid", new AMFDataItem(d));
                    responseFunction.addBody(aMFDataObj);
                    if (outputStream == null) {
                        responseFunctions.add(responseFunction);
                        break;
                    }
                    n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
                    break;
                }
                case 2: {
                    responseFunction = new ResponseFunction(this, this.getRespAMFDataObj());
                    responseFunction.createDefaultMessage("onStatus", 0.0);
                    responseFunction.setSrc(this.src);
                    responseFunction.setTimecode(l);
                    aMFDataObj = new AMFDataObj();
                    aMFDataObj.put("level", new AMFDataItem("status"));
                    aMFDataObj.put("code", new AMFDataItem("NetStream.Unpause.Notify"));
                    aMFDataObj.put("description", new AMFDataItem("Unpausing " + this.name + "."));
                    aMFDataObj.put("details", new AMFDataItem(this.name));
                    aMFDataObj.put("clientid", new AMFDataItem(d));
                    responseFunction.addBody(aMFDataObj);
                    if (outputStream == null) {
                        responseFunctions.add(responseFunction);
                        break;
                    }
                    n += responseFunction.write(outputStream, true, ((Client)this.client).getSendChunkSize());
                }
            }
        }
        return n;
    }

    @Override
    public boolean isAppend() {
        return this.isAppend;
    }

    @Override
    public void setAppend(boolean bl) {
        this.isAppend = bl;
    }

    @Override
    public void setPlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.player = iMediaStreamPlay;
    }

    @Override
    public IMediaStreamPlay getPlayer() {
        return this.player;
    }

    @Override
    public int getAudioMissing() {
        return this.getAudioSize() - this.audioBytes;
    }

    @Override
    public int getVideoMissing() {
        return this.getVideoSize() - this.videoBytes;
    }

    @Override
    public int getDataMissing() {
        return this.getDataSize() - this.dataBytes;
    }

    @Override
    public void addVideoData(byte[] byArray, int n, int n2) {
        this.videoBytes += n2;
        if (this.videoBytes == this.getVideoSize()) {
            this.videoBytes = 0;
        }
    }

    @Override
    public void addAudioData(byte[] byArray, int n, int n2) {
        this.audioBytes += n2;
        if (this.audioBytes == this.getAudioSize()) {
            this.audioBytes = 0;
        }
    }

    @Override
    public void addDataData(byte[] byArray, int n, int n2) {
        this.dataBytes += n2;
        if (this.dataBytes == this.getDataSize()) {
            this.dataBytes = 0;
        }
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public List<AMFPacket> getPlayPackets() {
        return null;
    }

    @Override
    public AMFPacket getLastKeyFrame() {
        return null;
    }

    @Override
    public AMFPacket getLastPacket() {
        return null;
    }

    @Override
    public long getMaxTimecode() {
        return -1L;
    }

    @Override
    public String getStreamType() {
        return this.streamType;
    }

    @Override
    public void setStreamType(String string) {
        this.streamType = string;
    }

    @Override
    public void sendDirect(String string, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        this.sendDirectInternal(string, aMFDataArray);
    }

    @Override
    public void sendDirect(String string) {
        this.sendDirectInternal(string, null);
    }

    public void sendDirectInternal(String string, AMFData[] aMFDataArray) {
        MediaStreamMap mediaStreamMap = this.parent;
        int n = mediaStreamMap.broadcastGetObjectEncoding(this);
        AMFDataList aMFDataList = new AMFDataList();
        aMFDataList.add(new AMFDataItem(string));
        if (aMFDataArray != null) {
            for (int i = 0; i < aMFDataArray.length; ++i) {
                aMFDataList.add(aMFDataArray[i]);
            }
        }
        byte[] byArray = null;
        AMFDataContextSerialize aMFDataContextSerialize = AMFData.createContextSerialize(0);
        if (n > 0) {
            byArray = new byte[]{0};
            aMFDataContextSerialize.setTargetEncoding(n);
        }
        byte[] byArray2 = aMFDataList.serialize(aMFDataContextSerialize, byArray);
        this.addSendDirectMessage(new SendDirectMessage(byArray2, n));
        IClient iClient = this.getClient();
        if (iClient != null) {
            ((Client)iClient).doIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSendDirectMessage(SendDirectMessage sendDirectMessage) {
        Object object = this.sendDirectLock;
        synchronized (object) {
            if (this.sendDirectMessages == null) {
                this.sendDirectMessages = new ArrayList<SendDirectMessage>();
            }
            this.sendDirectMessages.add(sendDirectMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendDirectMessages() {
        boolean bl = false;
        Object object = this.sendDirectLock;
        synchronized (object) {
            bl = this.sendDirectMessages != null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSendDirectMessages() {
        block6: {
            int n = this.getDataMissing();
            int n2 = this.getDataSize();
            if (n != 0 && n2 != n) break block6;
            ArrayList<SendDirectMessage> arrayList = null;
            Object object = this.sendDirectLock;
            synchronized (object) {
                if (this.sendDirectMessages != null) {
                    arrayList = new ArrayList<SendDirectMessage>();
                    arrayList.addAll(this.sendDirectMessages);
                    this.sendDirectMessages.clear();
                    this.sendDirectMessages = null;
                }
            }
            if (arrayList != null) {
                long l = Math.max(this.getAudioTC(), this.getVideoTC());
                for (SendDirectMessage sendDirectMessage : arrayList) {
                    this.setDataType(sendDirectMessage.objectEncoding > 0 ? 15 : 18);
                    this.setDataTC(l, true);
                    this.setDataSize(sendDirectMessage.msg.length);
                    this.startDataPacket();
                    this.addDataData(sendDirectMessage.msg, 0, sendDirectMessage.msg.length);
                }
                arrayList.clear();
                arrayList = null;
            }
        }
    }

    @Override
    public void send(String string, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        this.sendInternal(string, aMFDataArray);
    }

    @Override
    public void send(String string) {
        this.sendInternal(string, null);
    }

    public void sendInternal(String string, AMFData[] aMFDataArray) {
        MediaStreamMap mediaStreamMap = this.parent;
        int n = mediaStreamMap.broadcastGetObjectEncoding(this);
        AMFDataList aMFDataList = new AMFDataList();
        aMFDataList.add(new AMFDataItem(string));
        if (aMFDataArray != null) {
            for (int i = 0; i < aMFDataArray.length; ++i) {
                aMFDataList.add(aMFDataArray[i]);
            }
        }
        byte[] byArray = null;
        AMFDataContextSerialize aMFDataContextSerialize = AMFData.createContextSerialize(0);
        if (n > 0) {
            byArray = new byte[]{0};
            aMFDataContextSerialize.setTargetEncoding(n);
        }
        byte[] byArray2 = aMFDataList.serialize(aMFDataContextSerialize, byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        mediaStreamMap.broadcasePlayMessage(this, 0L, byteBuffer, n);
    }

    @Override
    public void close() {
        this.isOpen = false;
        if (this.player != null) {
            this.player.close();
        }
        this.reset();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void setOpen(boolean bl) {
        this.isOpen = bl;
    }

    @Override
    public FastPlaySettings getFastPlaySettings() {
        return this.fastPlaySettings;
    }

    @Override
    public void setFastPlaySettings(FastPlaySettings fastPlaySettings) {
        this.fastPlaySettings = fastPlaySettings;
    }

    @Override
    public void clearFastPlaySettings() {
        this.fastPlaySettings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReceiveAudio() {
        MediaStream mediaStream = this;
        synchronized (mediaStream) {
            return this.receiveAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReceiveAudio(boolean bl) {
        MediaStream mediaStream = this;
        synchronized (mediaStream) {
            this.receiveAudio = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReceiveVideo() {
        MediaStream mediaStream = this;
        synchronized (mediaStream) {
            return this.receiveVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReceiveVideo(boolean bl) {
        MediaStream mediaStream = this;
        synchronized (mediaStream) {
            this.receiveVideo = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getReceiveVideoFPS() {
        MediaStream mediaStream = this;
        synchronized (mediaStream) {
            return this.receiveVideoFPS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReceiveVideoFPS(int n) {
        MediaStream mediaStream = this;
        synchronized (mediaStream) {
            this.receiveVideoFPS = n;
        }
    }

    @Override
    public INetConnection getNetConnection() {
        return this.netConnection;
    }

    @Override
    public void setNetConnection(INetConnection iNetConnection) {
        this.netConnection = iNetConnection;
    }

    @Override
    public void handleCallback(RequestFunction requestFunction) {
        String string;
        IMediaStreamCallback iMediaStreamCallback;
        AMFDataList aMFDataList = requestFunction.getMessage();
        AMFData aMFData = aMFDataList.get(0);
        if (aMFData.getType() == 2 && (iMediaStreamCallback = (IMediaStreamCallback)this.callbacks.get(string = (String)aMFData.getValue())) != null) {
            iMediaStreamCallback.onCallback(this, requestFunction, aMFDataList);
        }
    }

    @Override
    public void unregisterCallback(String string) {
        this.callbacks.remove(string);
    }

    @Override
    public void registerCallback(String string, IMediaStreamCallback iMediaStreamCallback) {
        this.callbacks.put(string, iMediaStreamCallback);
    }

    @Override
    public void unregisterOnStatus(IMediaStreamCallback iMediaStreamCallback) {
        this.unregisterCallback("onStatus");
    }

    @Override
    public void registerOnStatus(IMediaStreamCallback iMediaStreamCallback) {
        this.registerCallback("onStatus", iMediaStreamCallback);
    }

    @Override
    public void unregisterOnPlayStatus(IMediaStreamCallback iMediaStreamCallback) {
        this.unregisterCallback("onPlayStatus");
    }

    @Override
    public void registerOnPlayStatus(IMediaStreamCallback iMediaStreamCallback) {
        this.registerCallback("onPlayStatus", iMediaStreamCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientListener(IMediaStreamActionNotify iMediaStreamActionNotify) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.add(iMediaStreamActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientListener(IMediaStreamActionNotify2 iMediaStreamActionNotify2) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.add(iMediaStreamActionNotify2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientListener(IMediaStreamActionNotify iMediaStreamActionNotify) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.remove(iMediaStreamActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientListener(IMediaStreamActionNotify2 iMediaStreamActionNotify2) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.remove(iMediaStreamActionNotify2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionPlay(String string, double d, double d2, int n) {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            iMediaStreamActionNotify.onPlay(this, string, d, d2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionPause(boolean bl, long l) {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            iMediaStreamActionNotify.onPause(this, bl, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionPauseRaw(boolean bl, long l) {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            if (!(iMediaStreamActionNotify instanceof IMediaStreamActionNotify2)) continue;
            ((IMediaStreamActionNotify2)iMediaStreamActionNotify).onPauseRaw(this, bl, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionSeek(double d) {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            iMediaStreamActionNotify.onSeek(this, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionPublish(String string, boolean bl, boolean bl2) {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            iMediaStreamActionNotify.onPublish(this, string, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionUnPublish(String string, boolean bl, boolean bl2) {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            iMediaStreamActionNotify.onUnPublish(this, string, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionOnMetaData(AMFPacket aMFPacket) {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            if (!(iMediaStreamActionNotify instanceof IMediaStreamActionNotify2)) continue;
            ((IMediaStreamActionNotify2)iMediaStreamActionNotify).onMetaData(this, aMFPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActionStop() {
        ArrayList arrayList = null;
        List list = this.actionListeners;
        synchronized (list) {
            arrayList = new ArrayList(this.actionListeners);
        }
        for (IMediaStreamActionNotify iMediaStreamActionNotify : arrayList) {
            iMediaStreamActionNotify.onStop(this);
        }
    }

    @Override
    public IOPerformanceCounter getMediaIOPerformance() {
        return this.mediaIOPerformance;
    }

    @Override
    public long incrementMediaOutBytes(long l, long l2) {
        return this.mediaIOPerformance.incrementMessagesOut(l, l2);
    }

    @Override
    public long incrementMediaLossBytes(long l, long l2) {
        return this.mediaIOPerformance.incrementMessagesLoss(l, l2);
    }

    @Override
    public long incrementMediaInBytes(long l) {
        return this.mediaIOPerformance.incrementMessagesIn(l);
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    @Override
    public void setClustered(boolean bl) {
        this.isClustered = bl;
    }

    @Override
    public String getCacheName() {
        return this.parent.getVHost().getName() + "." + this.parent.getAppName() + "." + (this.isPlay ? "play" : "streams") + "." + this.parent.getAppInstanceName() + "." + this.name;
    }

    @Override
    public void startPublishing() {
    }

    @Override
    public void stopPublishing() {
    }

    @Override
    public File getStreamFileForWrite() {
        return this.parent.getAppInstance().getStreamFileMapper().streamToFileForWrite(this);
    }

    @Override
    public File getStreamFileForWrite(String string, String string2, String string3) {
        return this.parent.getAppInstance().getStreamFileMapper().streamToFileForWrite(this, string, string2, string3);
    }

    @Override
    public File getStreamFileForRead() {
        return this.parent.getAppInstance().getStreamFileMapper().streamToFileForRead(this);
    }

    @Override
    public File getStreamFileForRead(String string, String string2, String string3) {
        return this.parent.getAppInstance().getStreamFileMapper().streamToFileForRead(this, string, string2, string3);
    }

    @Override
    public AMFObj getRespAMFAudioObj() {
        return this.client != null ? this.client.getRespAMFAudioObj(this) : null;
    }

    @Override
    public AMFObj getRespAMFVideoObj() {
        return this.client != null ? this.client.getRespAMFVideoObj(this) : null;
    }

    @Override
    public AMFObj getRespAMFDataObj() {
        AMFObj aMFObj = null;
        if (this.client != null && (aMFObj = this.client.getRespAMFDataObj(this)) == null) {
            aMFObj = this.client.getResponseAMFObj(3);
        }
        return aMFObj;
    }

    @Override
    public String getQueryStr() {
        return this.queryStr;
    }

    @Override
    public void setQueryStr(String string) {
        this.queryStr = string;
    }

    @Override
    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    @Override
    public void clearLoggingValues() {
        WMSLoggerFactory.removeGlobalLogValue("cs-stream-bytes");
        WMSLoggerFactory.removeGlobalLogValue("sc-stream-bytes");
        WMSLoggerFactory.removeGlobalLogValue("x-sname");
        WMSLoggerFactory.removeGlobalLogValue("x-suri-query");
        WMSLoggerFactory.removeGlobalLogValue("x-sname-query");
        WMSLoggerFactory.removeGlobalLogValue("x-suri-stem");
        WMSLoggerFactory.removeGlobalLogValue("x-suri");
        WMSLoggerFactory.removeGlobalLogValue("x-file-name");
        WMSLoggerFactory.removeGlobalLogValue("x-file-ext");
        WMSLoggerFactory.removeGlobalLogValue("x-file-size");
        WMSLoggerFactory.removeGlobalLogValue("x-file-length");
        WMSLoggerFactory.removeGlobalLogValue("x-spos");
        WMSLoggerFactory.removeGlobalLogValue("x-stream-id");
    }

    @Override
    public void updateLoggingValues() {
        WMSLoggerFactory.putGlobalLogValue("sc-stream-bytes", new Long(this.mediaIOPerformance.getMessagesOutBytes()));
        WMSLoggerFactory.putGlobalLogValue("cs-stream-bytes", new Long(this.mediaIOPerformance.getMessagesInBytes()));
        WMSLoggerFactory.putGlobalLogValue("x-stream-id", this.getSrc());
        WMSLoggerFactory.putGlobalLogValue("x-sname", this.getName());
        WMSLoggerFactory.putGlobalLogValue("x-ctx", this.getName());
        IClient iClient = this.getClient();
        String string = this.getName();
        if (string == null) {
            string = STREAM_DEFAULTNAME;
        }
        String string2 = (iClient == null ? STREAM_DEFAULTNAME : iClient.getUri()) + (string.length() > 0 ? "/" + this.getName() : STREAM_DEFAULTNAME);
        WMSLoggerFactory.putGlobalLogValue("x-suri-stem", string2);
        if (this.queryStr.length() > 0) {
            WMSLoggerFactory.putGlobalLogValue("x-suri-query", this.queryStr);
            WMSLoggerFactory.putGlobalLogValue("x-sname-query", this.queryStr);
            string2 = string2 + "?" + this.queryStr;
        } else {
            WMSLoggerFactory.removeGlobalLogValue("x-suri-query");
            WMSLoggerFactory.removeGlobalLogValue("x-sname-query");
        }
        WMSLoggerFactory.putGlobalLogValue("x-suri", string2);
        if (this.isPlay() && this.player != null) {
            this.player.updateLoggingValues();
        }
    }

    @Override
    public String getExt() {
        return this.ext;
    }

    @Override
    public void setExt(String string) {
        this.ext = string;
    }

    @Override
    public double length() {
        double d = 0.0;
        if (this.isPlay && this.player != null) {
            d = this.player.length();
        }
        return d;
    }

    @Override
    public long size() {
        long l = 0L;
        if (this.isPlay && this.player != null) {
            l = this.player.size();
        }
        return l;
    }

    @Override
    public void clear() {
        File file = this.getStreamFileForRead();
        if (file != null && file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStream.class).error("clear:" + exception.toString());
            }
        }
    }

    @Override
    public boolean isSendPlayStopLogEvent() {
        return this.sendPlayStopLogEvent;
    }

    @Override
    public void setSendPlayStopLogEvent(boolean bl) {
        this.sendPlayStopLogEvent = bl;
    }

    @Override
    public boolean isSendRecordStopLogEvent() {
        return this.sendRecordStopLogEvent;
    }

    @Override
    public void setSendRecordStopLogEvent(boolean bl) {
        this.sendRecordStopLogEvent = bl;
    }

    @Override
    public boolean isSendPublishStopLogEvent() {
        return this.sendPublishStopLogEvent;
    }

    @Override
    public void setSendPublishStopLogEvent(boolean bl) {
        this.sendPublishStopLogEvent = bl;
    }

    @Override
    public abstract void publish();

    @Override
    public abstract void trim();

    @Override
    public boolean[] getAccess(IClient iClient, String string) {
        String string2;
        int n;
        String[] stringArray;
        boolean[] blArray = new boolean[4];
        String string3 = iClient.getStreamReadAccess();
        String string4 = iClient.getStreamWriteAccess();
        String string5 = iClient.getStreamAudioSampleAccess();
        String string6 = iClient.getStreamVideoSampleAccess();
        if (string3.equals("*")) {
            blArray[0] = true;
        } else if (string3.equals(STREAM_DEFAULTNAME)) {
            blArray[0] = false;
        } else {
            blArray[0] = false;
            stringArray = string3.split("[;]");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].trim();
                if (string2.length() <= 0 || !string.startsWith(string2)) continue;
                blArray[0] = true;
                break;
            }
        }
        if (string4.equals("*")) {
            blArray[1] = true;
        } else if (string4.equals(STREAM_DEFAULTNAME)) {
            blArray[1] = false;
        } else {
            blArray[1] = false;
            stringArray = string4.split("[;]");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].trim();
                if (string2.length() <= 0 || !string.startsWith(string2)) continue;
                blArray[1] = true;
                break;
            }
        }
        if (string5.equals("*")) {
            blArray[2] = true;
        } else if (string5.equals(STREAM_DEFAULTNAME)) {
            blArray[2] = false;
        } else {
            blArray[2] = false;
            stringArray = string5.split("[;]");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].trim();
                if (string2.length() <= 0 || !string.startsWith(string2)) continue;
                blArray[2] = true;
                break;
            }
        }
        if (string6.equals("*")) {
            blArray[3] = true;
        } else if (string6.equals(STREAM_DEFAULTNAME)) {
            blArray[3] = false;
        } else {
            blArray[3] = false;
            stringArray = string6.split("[;]");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n].trim();
                if (string2.length() <= 0 || !string.startsWith(string2)) continue;
                blArray[3] = true;
                break;
            }
        }
        return blArray;
    }

    @Override
    public IMediaStreamMetaDataProvider getMetaDataProvider() {
        return this.metaDataProvider;
    }

    @Override
    public void setMetaDataProvider(IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider) {
        this.metaDataProvider = iMediaStreamMetaDataProvider;
    }

    @Override
    public int getHeaderSize() {
        return this.headerSize;
    }

    @Override
    public void setHeaderSize(int n) {
        this.headerSize = n;
    }

    @Override
    public AMFPacket getAudioCodecConfigPacket(long l) {
        return null;
    }

    @Override
    public void addAudioCodecConfigPacket(long l, AMFPacket aMFPacket) {
    }

    @Override
    public AMFPacket getVideoCodecConfigPacket(long l) {
        return null;
    }

    @Override
    public void addVideoCodecConfigPacket(long l, AMFPacket aMFPacket) {
    }

    @Override
    public RTPStream getRTPStream() {
        return this.rtpStream;
    }

    @Override
    public void setRTPStream(RTPStream rTPStream) {
        this.rtpStream = rTPStream;
    }

    @Override
    public IHTTPStreamerSession getHTTPStreamerSession() {
        return this.httpStreamerSession;
    }

    @Override
    public void setHTTPStreamerSession(IHTTPStreamerSession iHTTPStreamerSession) {
        this.httpStreamerSession = iHTTPStreamerSession;
    }

    @Override
    public void flush() {
    }

    @Override
    public String getLiveStreamPacketizerList() {
        return this.liveStreamPacketizerList;
    }

    @Override
    public void setLiveStreamPacketizerList(String string) {
        this.liveStreamPacketizerList = string;
    }

    @Override
    public ILiveStreamPacketizer getLiveStreamPacketizer(String string) {
        return null;
    }

    @Override
    public String getUniqueStreamIdStr() {
        if (this.client != null) {
            return this.client.getClientId() + "_" + this.src;
        }
        return this.src + STREAM_DEFAULTNAME;
    }

    @Override
    public ElapsedTimer getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public String getLiveStreamPacketizer() {
        return this.liveStreamPacketizer;
    }

    @Override
    public void setLiveStreamPacketizer(String string) {
        this.liveStreamPacketizer = string;
    }

    @Override
    public String getLiveStreamRepeater() {
        return this.liveStreamRepeater;
    }

    @Override
    public void setLiveStreamRepeater(String string) {
        this.liveStreamRepeater = string;
    }

    @Override
    public void initLiveStreamRepeating(String string, String string2) {
        this.liveStreamPacketizer = string;
        this.liveStreamRepeater = string2;
        if (this.player != null) {
            this.player.initLiveStreamRepeating(string, string2);
        }
    }

    @Override
    public int getPublishVideoCodecId() {
        return -1;
    }

    @Override
    public void setPublishVideoCodecId(int n) {
    }

    @Override
    public int getPublishAudioCodecId() {
        return -1;
    }

    @Override
    public void setPublishAudioCodecId(int n) {
    }

    @Override
    public boolean isPublishStreamReady(boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public String getContextStr() {
        String string = this.getName();
        IApplicationInstance iApplicationInstance = this.parent.getAppInstance();
        if (iApplicationInstance != null) {
            string = iApplicationInstance.getContextStr() + "/" + string;
        }
        return string;
    }

    @Override
    public boolean isMediaCasterPlay() {
        return this.isMediaCasterPlay;
    }

    @Override
    public void setMediaCasterPlay(boolean bl) {
        this.isMediaCasterPlay = bl;
    }

    @Override
    public boolean isMergeOnMetadata() {
        return this.mergeOnMetadata;
    }

    @Override
    public void setMergeOnMetadata(boolean bl) {
        this.mergeOnMetadata = bl;
    }

    class SendDirectMessage {
        byte[] msg = null;
        int objectEncoding = 0;

        public SendDirectMessage(byte[] byArray, int n) {
            this.msg = byArray;
            this.objectEncoding = n;
        }
    }
}

