/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamTimecodeControl;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.HashMap;
import java.util.Map;

public class MediaStreamVODTest
extends MediaStream
implements IMediaStreamTimecodeControl {
    public static final long MINBEHIND = -100000000000L;
    private boolean gotStartTimecode = false;
    private long startRealTC = 0L;
    private int audioBytes = 0;
    private int videoBytes = 0;
    private int dataBytes = 0;
    private long accumAudioTC = 0L;
    private long accumVideoTC = 0L;
    private long accumDataTC = 0L;
    private boolean isBehind = false;
    private long maxBehind = -100000000000L;
    private static Map<Integer, BehindHolder> behindList = new HashMap<Integer, BehindHolder>();
    private static long behindTime = 0L;
    private static int behindCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBehindList(int n, IMediaStream iMediaStream) {
        Map<Integer, BehindHolder> map = behindList;
        synchronized (map) {
            behindList.put(new Integer(n), new BehindHolder(iMediaStream));
            ++behindCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBehindList(int n, IMediaStream iMediaStream) {
        Map<Integer, BehindHolder> map = behindList;
        synchronized (map) {
            BehindHolder behindHolder = behindList.remove(new Integer(n));
            if (behindHolder != null) {
                behindTime += behindHolder.getTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBehindTotalCount() {
        int n = 0;
        Map<Integer, BehindHolder> map = behindList;
        synchronized (map) {
            n = behindCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBehindCurrCount() {
        int n = 0;
        Map<Integer, BehindHolder> map = behindList;
        synchronized (map) {
            n = behindList.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getBehindTime() {
        long l = 0L;
        Map<Integer, BehindHolder> map = behindList;
        synchronized (map) {
            l = behindTime;
        }
        return l;
    }

    public void init(MediaStreamMap mediaStreamMap, int n, WMSProperties wMSProperties) {
        super.init(mediaStreamMap, n, wMSProperties);
    }

    public void publish() {
    }

    public void trim() {
    }

    public int getAudioMissing() {
        return this.getAudioSize() - this.audioBytes;
    }

    public int getVideoMissing() {
        return this.getVideoSize() - this.videoBytes;
    }

    public int getDataMissing() {
        return this.getDataSize() - this.dataBytes;
    }

    public void addVideoData(byte[] byArray, int n, int n2) {
        this.videoBytes += n2;
        if (this.videoBytes == this.getVideoSize()) {
            this.videoBytes = 0;
            this.accumVideoTC = this.getVideoTC();
        }
    }

    public void addDataData(byte[] byArray, int n, int n2) {
        this.dataBytes += n2;
        if (this.dataBytes == this.getDataSize()) {
            this.dataBytes = 0;
            this.accumDataTC = this.getDataTC();
        }
    }

    public void addAudioData(byte[] byArray, int n, int n2) {
        this.audioBytes += n2;
        if (this.audioBytes == this.getAudioSize()) {
            this.audioBytes = 0;
            this.accumAudioTC = this.getAudioTC();
        }
    }

    public void packetComplete() {
        if (this.gotStartTimecode) {
            long l = System.currentTimeMillis() - this.startRealTC;
            long l2 = Math.max(this.accumAudioTC, this.accumVideoTC);
            long l3 = l2 - l;
            if (l3 < 500L) {
                if (!this.isBehind) {
                    MediaStreamVODTest.addBehindList(this.getSrc(), this);
                }
                this.maxBehind = this.maxBehind == -100000000000L ? l3 : Math.min(this.maxBehind, l3);
                this.isBehind = true;
            } else {
                if (this.isBehind) {
                    MediaStreamVODTest.removeBehindList(this.getSrc(), this);
                }
                this.isBehind = false;
                this.maxBehind = -100000000000L;
            }
        } else if (this.accumAudioTC > 2500L) {
            this.startRealTC = System.currentTimeMillis();
            this.gotStartTimecode = true;
        }
    }

    public void resetTimecodes() {
        this.gotStartTimecode = false;
        this.startRealTC = 0L;
        this.audioBytes = 0;
        this.videoBytes = 0;
        this.dataBytes = 0;
        this.accumAudioTC = 0L;
        this.accumVideoTC = 0L;
        this.accumDataTC = 0L;
        this.isBehind = false;
        this.maxBehind = -100000000000L;
    }

    static class BehindHolder {
        public IMediaStream stream = null;
        public long startTime = 0L;

        public BehindHolder(IMediaStream iMediaStream) {
            this.stream = iMediaStream;
            this.startTime = System.currentTimeMillis();
        }

        public long getTime() {
            return System.currentTimeMillis() - this.startTime;
        }
    }
}

