/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.monitor;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.util.List;

public class MediaStreamMonitor {
    public boolean debugLog = false;
    public static final int MONITORSTATE_HEALTHY = 0;
    public static final int MONITORSTATE_NOTSTARTED = 1;
    public static final int MONITORSTATE_STREAMSTARTUPTIMEOUT = 2;
    public static final int MONITORSTATE_STREAMTIMEOUT = 3;
    public static final int MONITORSTATE_VIDEOOUTOFNEGTOLERANCE = 4;
    public static final int MONITORSTATE_VIDEOOUTOFPOSTOLERANCE = 5;
    public static final int MONITORSTATE_AUDIOOUTOFNEGTOLERANCE = 6;
    public static final int MONITORSTATE_AUDIOOUTOFPOSTOLERANCE = 7;
    public static final int MONITORSTATE_DATAOUTOFNEGTOLERANCE = 8;
    public static final int MONITORSTATE_DATAOUTOFPOSTOLERANCE = 9;
    public static final int MONITORSTATE_AVSYNCOUTOFTOLERANCE = 10;
    public static final int MONITORSTATE_VIDEOSTARTUPTIMEOUT = 11;
    public static final int MONITORSTATE_VIDEOTIMEOUT = 12;
    public static final int MONITORSTATE_AUDIOSTARTUPTIMEOUT = 13;
    public static final int MONITORSTATE_AUDIOTIMEOUT = 14;
    protected Object lock = new Object();
    protected IMediaStream stream = null;
    protected int healthState = 1;
    protected long lastSeq = -1L;
    protected long lastVideoTC = -1L;
    protected long lastAudioTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastVideoRT = -1L;
    protected long lastAudioRT = -1L;
    protected long lastDataRT = -1L;
    protected long lastNewPacketsRT = -1L;
    protected long firstMonitorTC = -1L;
    protected boolean isStreamStarted = false;
    protected int audioOutOfToleranceCount = 0;
    protected int videoOutOfToleranceCount = 0;
    protected int dataOutOfToleranceCount = 0;
    protected int avSyncOutOfToleranceCount = 0;
    protected int streamMonitorStreamStartTimeout = 20000;
    protected int streamMonitorStreamTimeout = 12000;
    protected int streamMonitorVideoStartTimeout = 0;
    protected int streamMonitorVideoTimeout = 0;
    protected int streamMonitorAudioStartTimeout = 0;
    protected int streamMonitorAudioTimeout = 0;
    protected boolean streamMonitorVideoTCToleranceEnable = false;
    protected int streamMonitorVideoTCPosTolerance = 3000;
    protected int streamMonitorVideoTCNegTolerance = -500;
    protected boolean streamMonitorAudioTCToleranceEnable = false;
    protected int streamMonitorAudioTCPosTolerance = 3000;
    protected int streamMonitorAudioTCNegTolerance = -500;
    protected boolean streamMonitorDataTCToleranceEnable = false;
    protected int streamMonitorDataTCPosTolerance = 3000;
    protected int streamMonitorDataTCNegTolerance = -500;
    protected boolean streamMonitorAVSyncToleranceEnable = false;
    protected int streamMonitorAVSyncTolerance = 1500;

    public void init(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
        if (WMSLoggerFactory.getLogger(MediaStreamMonitor.class).isDebugEnabled()) {
            this.debugLog = true;
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public void close() {
        this.stream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.healthState = 1;
            this.lastSeq = -1L;
            this.lastVideoTC = -1L;
            this.lastAudioTC = -1L;
            this.lastDataTC = -1L;
            this.lastVideoRT = -1L;
            this.lastAudioRT = -1L;
            this.lastDataRT = -1L;
            this.lastNewPacketsRT = -1L;
            this.firstMonitorTC = -1L;
            this.isStreamStarted = false;
            this.audioOutOfToleranceCount = 0;
            this.videoOutOfToleranceCount = 0;
            this.dataOutOfToleranceCount = 0;
            this.avSyncOutOfToleranceCount = 0;
        }
    }

    private String getContextStr() {
        return this.stream == null ? "unknown" : this.stream.getContextStr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        long l = System.currentTimeMillis();
        if (this.firstMonitorTC < 0L) {
            this.firstMonitorTC = l;
        }
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Object object = this.lock;
            synchronized (object) {
                int n5;
                List<AMFPacket> list;
                if (this.stream != null && (list = this.stream.getPlayPackets()) != null && (n5 = list.size()) > 0) {
                    int n6;
                    bl = true;
                    AMFPacket aMFPacket = list.get(n5 - 1);
                    int n7 = n6 = this.lastSeq < 0L ? 0 : (int)((long)n5 - (aMFPacket.getSeq() - this.lastSeq));
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    for (int i = n6; i < n5; ++i) {
                        long l2;
                        AMFPacket aMFPacket2 = list.get(i);
                        this.lastSeq = aMFPacket2.getSeq();
                        ++n;
                        int n8 = aMFPacket2.getType();
                        long l3 = aMFPacket2.getAbsTimecode();
                        switch (n8) {
                            case 15: 
                            case 18: {
                                if (this.lastDataTC >= 0L) {
                                    if (l3 - this.lastDataTC > (long)this.streamMonitorDataTCPosTolerance) {
                                        bl5 = true;
                                        ++this.dataOutOfToleranceCount;
                                    } else if (l3 - this.lastDataTC < (long)this.streamMonitorDataTCNegTolerance) {
                                        bl8 = true;
                                        ++this.dataOutOfToleranceCount;
                                    }
                                }
                                this.lastDataTC = l3;
                                this.lastDataRT = l;
                                ++n4;
                                break;
                            }
                            case 9: {
                                if (this.lastVideoTC >= 0L) {
                                    if (l3 - this.lastVideoTC > (long)this.streamMonitorVideoTCPosTolerance) {
                                        bl3 = true;
                                        ++this.videoOutOfToleranceCount;
                                    } else if (l3 - this.lastVideoTC < (long)this.streamMonitorVideoTCNegTolerance) {
                                        bl6 = true;
                                        ++this.videoOutOfToleranceCount;
                                    }
                                }
                                this.lastVideoTC = l3;
                                this.lastVideoRT = l;
                                ++n2;
                                break;
                            }
                            case 8: {
                                if (this.lastAudioTC >= 0L) {
                                    if (l3 - this.lastAudioTC > (long)this.streamMonitorAudioTCPosTolerance) {
                                        bl4 = true;
                                        ++this.audioOutOfToleranceCount;
                                    } else if (l3 - this.lastAudioTC < (long)this.streamMonitorAudioTCNegTolerance) {
                                        bl7 = true;
                                        ++this.audioOutOfToleranceCount;
                                    }
                                }
                                this.lastAudioTC = l3;
                                this.lastAudioRT = l;
                                ++n3;
                            }
                        }
                        if (this.lastVideoTC < 0L || this.lastAudioTC < 0L || n8 != 9 && n8 != 8 || (l2 = Math.abs(this.lastVideoTC - this.lastAudioTC)) <= (long)this.streamMonitorAVSyncTolerance) continue;
                        bl9 = true;
                        ++this.avSyncOutOfToleranceCount;
                    }
                    bl2 = n > 0;
                }
                int n9 = -1;
                if (!this.isStreamStarted) {
                    if (bl) {
                        this.isStreamStarted = true;
                    } else if (l - this.firstMonitorTC > (long)this.streamMonitorStreamStartTimeout && this.streamMonitorStreamStartTimeout > 0) {
                        n9 = 2;
                    }
                }
                if (this.isStreamStarted && n9 < 0) {
                    if (bl2) {
                        this.lastNewPacketsRT = l;
                    } else if (l - this.lastNewPacketsRT > (long)this.streamMonitorStreamTimeout && this.streamMonitorStreamTimeout > 0) {
                        n9 = 3;
                    }
                    if (n9 < 0) {
                        if (this.lastVideoTC < 0L) {
                            if (this.streamMonitorVideoStartTimeout > 0 && l - this.firstMonitorTC > (long)this.streamMonitorVideoStartTimeout) {
                                n9 = 11;
                            }
                        } else if (n2 <= 0 && this.streamMonitorVideoTimeout > 0 && l - this.lastVideoRT > (long)this.streamMonitorVideoTimeout) {
                            n9 = 12;
                        }
                        if (n9 < 0) {
                            if (this.lastAudioTC < 0L) {
                                if (this.streamMonitorAudioStartTimeout > 0 && l - this.firstMonitorTC > (long)this.streamMonitorAudioStartTimeout) {
                                    n9 = 13;
                                }
                            } else if (n3 <= 0 && this.streamMonitorAudioTimeout > 0 && l - this.lastAudioRT > (long)this.streamMonitorAudioTimeout) {
                                n9 = 14;
                            }
                            if (n9 < 0) {
                                if (this.streamMonitorVideoTCToleranceEnable) {
                                    if (bl6) {
                                        n9 = 4;
                                    } else if (bl3) {
                                        n9 = 5;
                                    }
                                }
                                if (this.streamMonitorAudioTCToleranceEnable) {
                                    if (bl7) {
                                        n9 = 6;
                                    } else if (bl4) {
                                        n9 = 7;
                                    }
                                }
                                if (this.streamMonitorDataTCToleranceEnable) {
                                    if (bl8) {
                                        n9 = 8;
                                    } else if (bl5) {
                                        n9 = 9;
                                    }
                                }
                                if (this.streamMonitorAVSyncToleranceEnable && bl9) {
                                    n9 = 10;
                                }
                            }
                        }
                    }
                }
                if (n9 >= 0) {
                    this.healthState = n9;
                } else if (this.healthState == 1 && this.isStreamStarted) {
                    this.healthState = 0;
                }
                if (this.debugLog) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("MediaStreamMonitor.monitor[" + this.getContextStr() + "]:");
                    stringBuffer.append(" state:" + this.healthState);
                    stringBuffer.append(" t/a/v/d:" + n + "/" + n3 + "/" + n2 + "/" + n4);
                    stringBuffer.append(" aTol:" + this.audioOutOfToleranceCount + ":" + this.streamMonitorAudioTCToleranceEnable);
                    stringBuffer.append(" vTol:" + this.videoOutOfToleranceCount + ":" + this.streamMonitorVideoTCToleranceEnable);
                    stringBuffer.append(" sTol:" + this.avSyncOutOfToleranceCount + ":" + this.streamMonitorAVSyncToleranceEnable);
                    WMSLoggerFactory.getLogger(MediaStreamMonitor.class).info(stringBuffer.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMonitor.class).error("MediaStreamMonitor.monitor: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHealthState() {
        Object object = this.lock;
        synchronized (object) {
            return this.healthState;
        }
    }

    public static String healthStateToName(int n) {
        String string = "unknown";
        switch (n) {
            case 0: {
                string = "healthy";
                break;
            }
            case 1: {
                string = "not started";
                break;
            }
            case 2: {
                string = "stream startup timeout";
                break;
            }
            case 3: {
                string = "stream timeout";
                break;
            }
            case 4: {
                string = "video out of neg tolerance";
                break;
            }
            case 5: {
                string = "video out of pos tolerance";
                break;
            }
            case 6: {
                string = "audio out of neg tolerance";
                break;
            }
            case 7: {
                string = "audio out of pos tolerance";
                break;
            }
            case 8: {
                string = "data out of neg tolerance";
                break;
            }
            case 9: {
                string = "data out of pos tolerance";
                break;
            }
            case 10: {
                string = "avsync out of tolerance";
                break;
            }
            case 11: {
                string = "video startup timeout";
                break;
            }
            case 12: {
                string = "video timeout";
                break;
            }
            case 13: {
                string = "audio startup timeout";
                break;
            }
            case 14: {
                string = "audio timeout";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorStreamStartTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorStreamStartTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorStreamStartTimeout(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorStreamStartTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorStreamTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorStreamTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorStreamTimeout(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorStreamTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamMonitorVideoTCToleranceEnable() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorVideoTCToleranceEnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorVideoTCToleranceEnable(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorVideoTCToleranceEnable = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorVideoTCPosTolerance() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorVideoTCPosTolerance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorVideoTCPosTolerance(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorVideoTCPosTolerance = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorVideoTCNegTolerance() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorVideoTCNegTolerance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorVideoTCNegTolerance(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorVideoTCNegTolerance = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamMonitorAudioTCToleranceEnable() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorAudioTCToleranceEnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorAudioTCToleranceEnable(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorAudioTCToleranceEnable = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorAudioTCPosTolerance() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorAudioTCPosTolerance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorAudioTCPosTolerance(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorAudioTCPosTolerance = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorAudioTCNegTolerance() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorAudioTCNegTolerance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorAudioTCNegTolerance(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorAudioTCNegTolerance = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamMonitorDataTCToleranceEnable() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorDataTCToleranceEnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorDataTCToleranceEnable(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorDataTCToleranceEnable = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorDataTCPosTolerance() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorDataTCPosTolerance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorDataTCPosTolerance(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorDataTCPosTolerance = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorDataTCNegTolerance() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorDataTCNegTolerance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorDataTCNegTolerance(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorDataTCNegTolerance = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamMonitorAVSyncToleranceEnable() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorAVSyncToleranceEnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorAVSyncToleranceEnable(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorAVSyncToleranceEnable = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorAVSyncTolerance() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorAVSyncTolerance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorAVSyncTolerance(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorAVSyncTolerance = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstMonitorTC() {
        Object object = this.lock;
        synchronized (object) {
            return this.firstMonitorTC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAudioOutOfToleranceCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.audioOutOfToleranceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoOutOfToleranceCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.videoOutOfToleranceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataOutOfToleranceCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.dataOutOfToleranceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvSyncOutOfToleranceCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.avSyncOutOfToleranceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStream(IMediaStream iMediaStream) {
        Object object = this.lock;
        synchronized (object) {
            this.stream = iMediaStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorVideoStartTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorVideoStartTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorVideoStartTimeout(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorVideoStartTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorVideoTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorVideoTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorVideoTimeout(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorVideoTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorAudioStartTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorAudioStartTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorAudioStartTimeout(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorAudioStartTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamMonitorAudioTimeout() {
        Object object = this.lock;
        synchronized (object) {
            return this.streamMonitorAudioTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamMonitorAudioTimeout(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.streamMonitorAudioTimeout = n;
        }
    }
}

