/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.transport.udp.IUDPTransportOutgoing;
import com.wowza.wms.transport.udp.IUDPTransportOutgoingConnection;
import com.wowza.wms.transport.udp.MulticastOutgoingConnection;
import com.wowza.wms.transport.udp.UDPSender;
import com.wowza.wms.vhost.IVHost;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class MulticastOutgoing
implements IUDPTransportOutgoing {
    public static int MINCONNECTIONS = 20;
    private int processorCount = -1;
    private IVHost vhost = null;
    private Executor executor = null;
    private ConnectorHolder[] connectors = null;
    private List<MulticastOutgoingConnection> connections = new ArrayList<MulticastOutgoingConnection>();
    private Object lock = new Object();
    private long connectionCount = 0L;

    public void init(int n, IVHost iVHost) {
        this.processorCount = n;
        this.connectors = new ConnectorHolder[n];
        this.vhost = iVHost;
        this.executor = this.vhost.getTransportThreadPool().getExecutor();
    }

    private int getNextConnector() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.connectors.length; ++i) {
            if (this.connectors[i] == null) {
                this.connectors[i] = new ConnectorHolder(new UDPSender(this.executor));
                n = i;
                break;
            }
            if (this.connectors[i].count < MINCONNECTIONS) {
                n = i;
                break;
            }
            if (this.connectors[i].count >= n2) continue;
            n2 = this.connectors[i].count;
            n = i;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUDPTransportOutgoingConnection connect(RTPUDPDatagramConfig rTPUDPDatagramConfig, String string, int n) {
        MulticastOutgoingConnection multicastOutgoingConnection = null;
        MulticastSocket multicastSocket = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                int n2 = this.getNextConnector();
                ConnectorHolder connectorHolder = this.connectors[n2];
                InetAddress inetAddress = InetAddress.getByName(string);
                multicastSocket = new MulticastSocket(n);
                multicastSocket.setTrafficClass(rTPUDPDatagramConfig.getTrafficClass());
                multicastSocket.setReceiveBufferSize(rTPUDPDatagramConfig.getReceiveBufferSize());
                multicastSocket.setSendBufferSize(rTPUDPDatagramConfig.getSendBufferSize());
                multicastSocket.setReuseAddress(rTPUDPDatagramConfig.isReuseAddress());
                multicastSocket.setSoTimeout(rTPUDPDatagramConfig.getMulticastTimeout());
                multicastSocket.joinGroup(inetAddress);
                multicastOutgoingConnection = new MulticastOutgoingConnection(this, multicastSocket, connectorHolder.sender, n2);
                this.connections.add(multicastOutgoingConnection);
                ++connectorHolder.count;
                ++this.connectionCount;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MulticastOutgoing.class).error("MulticastOutgoing.connect: " + exception.toString());
        }
        if (multicastOutgoingConnection == null) {
            if (multicastSocket != null) {
                multicastOutgoingConnection.isOpen = false;
                try {
                    multicastSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            multicastSocket = null;
        }
        return multicastOutgoingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(IUDPTransportOutgoingConnection iUDPTransportOutgoingConnection) {
        Object object;
        MulticastOutgoingConnection multicastOutgoingConnection = null;
        DatagramSocket datagramSocket = null;
        try {
            object = this.lock;
            synchronized (object) {
                if (iUDPTransportOutgoingConnection instanceof MulticastOutgoingConnection && this.connections.contains(iUDPTransportOutgoingConnection)) {
                    multicastOutgoingConnection = (MulticastOutgoingConnection)iUDPTransportOutgoingConnection;
                    int n = multicastOutgoingConnection.connectorIndex;
                    ConnectorHolder connectorHolder = this.connectors[n];
                    --connectorHolder.count;
                    --this.connectionCount;
                    datagramSocket = multicastOutgoingConnection.socket;
                    this.connections.remove(multicastOutgoingConnection);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MulticastOutgoing.class).error("MulticastOutgoing.disconnect: " + exception.toString());
        }
        if (multicastOutgoingConnection != null) {
            object = multicastOutgoingConnection;
            synchronized (object) {
                multicastOutgoingConnection.isOpen = false;
                if (datagramSocket != null) {
                    try {
                        datagramSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                datagramSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionCount;
        }
    }

    class ConnectorHolder {
        public int count = 0;
        public UDPSender sender = null;

        public ConnectorHolder(UDPSender uDPSender) {
            this.sender = uDPSender;
        }
    }
}

