/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPTrack;

public class RTCPUtils {
    protected static final long msb0baseTime = 2085978496000L;
    protected static final long msb1baseTime = -2208988800000L;
    public static final byte[] SR_PACKET = new byte[]{-128, -56, 0, 6, 0, 0, 96, 78, -51, 100, 29, -18, 96, 0, 2, 34, 0, 0, 8, -102, 0, 0, 0, 1, 0, 0, 3, -8};

    public static byte[] createSenderReport(RTPTrack rTPTrack, long l, long l2, long l3, long l4) {
        byte[] byArray = null;
        try {
            byArray = new byte[SR_PACKET.length];
            System.arraycopy(SR_PACKET, 0, byArray, 0, byArray.length);
            long l5 = rTPTrack.getSSRC();
            int n = 4;
            BufferUtils.longToByteArray(l5, byArray, n, 4);
            BufferUtils.longToByteArray(l, byArray, n += 4, 8);
            BufferUtils.longToByteArray(l2, byArray, n += 8, 4);
            BufferUtils.longToByteArray(l3, byArray, n += 4, 4);
            BufferUtils.longToByteArray(l4, byArray, n += 4, 4);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTCPUtils.class).error("RTCPUtils.createSenderReport: " + exception.toString());
            exception.printStackTrace();
        }
        return byArray;
    }

    public static long toNtpTime(long l) {
        boolean bl = l < 2085978496000L;
        long l2 = bl ? l - -2208988800000L : l - 2085978496000L;
        long l3 = l2 / 1000L;
        long l4 = l2 % 1000L * 0x100000000L / 1000L;
        if (bl) {
            l3 |= 0x80000000L;
        }
        long l5 = l3 << 32 | l4;
        return l5;
    }
}

