/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.util.VHostListUtils;
import com.wowza.wms.vhost.IVHostItemNotify;
import com.wowza.wms.vhost.VHostItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VHostList {
    private Map<String, VHostItem> vhostMap = new HashMap<String, VHostItem>();
    private List<IVHostItemNotify> vhostListListeners = new ArrayList<IVHostItemNotify>();

    public void loadConfig() {
        String string = Bootstrap.getVHostsXMLURL();
        if (string != null) {
            VHostListUtils.loadConfigFile(this, string);
        } else {
            System.out.println("ERROR: VHosts.xml missing.");
        }
    }

    public void reloadConfig() {
        this.clearVisisted();
        this.loadConfig();
        this.destroyNonVisisted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearVisisted() {
        Map<String, VHostItem> map = this.vhostMap;
        synchronized (map) {
            for (VHostItem vHostItem : this.vhostMap.values()) {
                vHostItem.setVisited(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyNonVisisted() {
        Map<String, VHostItem> map = this.vhostMap;
        synchronized (map) {
            for (String string : new ArrayList<String>(this.vhostMap.keySet())) {
                VHostItem vHostItem = this.vhostMap.get(string);
                if (vHostItem.isVisited()) continue;
                this.notifyVHostItemDestroy(vHostItem);
                this.vhostMap.remove(string);
            }
        }
    }

    public Map<String, VHostItem> getVHostMap() {
        return this.vhostMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVHostItemListener(IVHostItemNotify iVHostItemNotify) {
        List<IVHostItemNotify> list = this.vhostListListeners;
        synchronized (list) {
            this.vhostListListeners.add(iVHostItemNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVHostItemListener(IVHostItemNotify iVHostItemNotify) {
        List<IVHostItemNotify> list = this.vhostListListeners;
        synchronized (list) {
            this.vhostListListeners.remove(iVHostItemNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVHostItemCreate(VHostItem vHostItem) {
        ArrayList<IVHostItemNotify> arrayList = null;
        List<IVHostItemNotify> list = this.vhostListListeners;
        synchronized (list) {
            arrayList = new ArrayList<IVHostItemNotify>(this.vhostListListeners);
        }
        for (IVHostItemNotify iVHostItemNotify : arrayList) {
            iVHostItemNotify.onVHostItemCreate(vHostItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVHostItemUpdate(VHostItem vHostItem) {
        ArrayList<IVHostItemNotify> arrayList = null;
        List<IVHostItemNotify> list = this.vhostListListeners;
        synchronized (list) {
            arrayList = new ArrayList<IVHostItemNotify>(this.vhostListListeners);
        }
        for (IVHostItemNotify iVHostItemNotify : arrayList) {
            iVHostItemNotify.onVHostItemUpdate(vHostItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVHostItemDestroy(VHostItem vHostItem) {
        ArrayList<IVHostItemNotify> arrayList = null;
        List<IVHostItemNotify> list = this.vhostListListeners;
        synchronized (list) {
            arrayList = new ArrayList<IVHostItemNotify>(this.vhostListListeners);
        }
        for (IVHostItemNotify iVHostItemNotify : arrayList) {
            iVHostItemNotify.onVHostItemDestroy(vHostItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getVHostNames() {
        Map<String, VHostItem> map = this.vhostMap;
        synchronized (map) {
            return new ArrayList<String>(this.vhostMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VHostItem> getVHostItems() {
        Map<String, VHostItem> map = this.vhostMap;
        synchronized (map) {
            return new ArrayList<VHostItem>(this.vhostMap.values());
        }
    }
}

