/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.livestreamrecord;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.integration.liverecord.ILiveStreamRecord;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderFLV;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderMP4;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModuleLiveStreamRecord
extends ModuleBase {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_FLV = 1;
    public static final int FORMAT_MP4 = 2;
    private Map<String, ILiveStreamRecord> recorders = new HashMap<String, ILiveStreamRecord>();
    private IApplicationInstance appInstance = null;

    public void recordStream(String streamName, int format, boolean append, String outputPath, boolean versionFile, boolean startOnKeyFrame, boolean recordData) {
        IMediaStream stream = this.appInstance.getStreams().getStream(streamName);
        if (stream != null) {
            this.recordStream(stream, format, append, outputPath, versionFile, startOnKeyFrame, recordData);
        } else {
            ModuleLiveStreamRecord.getLogger().warn("ModuleLiveStreamRecord.recordStream: Stream not found: " + streamName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordStream(IMediaStream stream, int format, boolean append, String outputPath, boolean versionFile, boolean startOnKeyFrame, boolean recordData) {
        String streamName = stream.getName();
        if (format == 0) {
            format = 1;
            String extStr = stream.getExt();
            if (extStr.equals("mp4")) {
                format = 2;
            }
        }
        String params = "stream:" + streamName;
        params = params + " format:" + (format == 2 ? "mp4" : "flv");
        params = params + " append:" + append;
        if (outputPath != null) {
            params = params + " outputPath:" + outputPath;
        } else {
            File writeFile = stream.getStreamFileForWrite(stream.getName(), format == 2 ? "mp4" : "flv", stream.getQueryStr());
            params = params + " outputPath:" + writeFile.getAbsolutePath();
        }
        params = params + " versionFile:" + versionFile;
        params = params + " startOnKeyFrame:" + startOnKeyFrame;
        params = params + " recordData:" + recordData;
        ModuleLiveStreamRecord.getLogger().info("ModuleStreamRecord.startRecording: " + params);
        Object recorder = null;
        recorder = format == 2 ? new LiveStreamRecorderMP4() : new LiveStreamRecorderFLV();
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            ILiveStreamRecord prevRecorder = this.recorders.get(streamName);
            if (prevRecorder != null) {
                prevRecorder.stopRecording();
            }
            this.recorders.put(streamName, (ILiveStreamRecord)recorder);
        }
        recorder.setRecordData(recordData);
        recorder.setVersionFile(versionFile);
        recorder.setStartOnKeyFrame(startOnKeyFrame);
        recorder.startRecording(stream, outputPath, append);
    }

    public void startRecording(IClient client, RequestFunction function, AMFDataList params) {
        IMediaStream stream;
        AMFDataObj dataObj;
        String streamName = params.getString(3);
        int format = 0;
        boolean append = true;
        String outputPath = null;
        boolean versionFile = true;
        boolean startOnKeyFrame = true;
        boolean recordData = false;
        if (4 < params.size() && (dataObj = params.getObject(4)) != null) {
            List keys = dataObj.getKeys();
            for (String key : keys) {
                try {
                    if (key.equalsIgnoreCase("format")) {
                        String value = dataObj.getString(key);
                        if (value.equals("flv")) {
                            format = 1;
                            continue;
                        }
                        if (!value.equals("mp4")) continue;
                        format = 2;
                        continue;
                    }
                    if (key.equalsIgnoreCase("append")) {
                        append = dataObj.getBoolean(key);
                        continue;
                    }
                    if (key.equalsIgnoreCase("outputPath")) {
                        outputPath = client.getAppInstance().decodeStorageDir(dataObj.getString(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase("versionFile")) {
                        versionFile = dataObj.getBoolean(key);
                        continue;
                    }
                    if (key.equalsIgnoreCase("startOnKeyFrame")) {
                        startOnKeyFrame = dataObj.getBoolean(key);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("recordData")) continue;
                    recordData = dataObj.getBoolean(key);
                }
                catch (Exception e) {
                    ModuleLiveStreamRecord.getLogger().error("ModuleLiveStreamRecord.startRecording: Error processing param[" + key + "]: " + e.toString());
                }
            }
        }
        IApplicationInstance appInstance = client.getAppInstance();
        String streamTypeStr = "default";
        String tmpStr = client.getStreamType();
        if (tmpStr != null) {
            streamTypeStr = tmpStr;
        }
        boolean isLiveRepeaterEdge = false;
        StreamList streamDefs = appInstance.getVHost().getStreamTypes();
        StreamItem streamDef = streamDefs.getStreamDef(streamTypeStr);
        if (streamDef != null) {
            isLiveRepeaterEdge = streamDef.getProperties().getPropertyBoolean("isLiveRepeaterEdge", isLiveRepeaterEdge);
        }
        if (isLiveRepeaterEdge) {
            streamName = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)appInstance, (IClient)client, (String)streamName);
        }
        if ((stream = appInstance.getStreams().getStream(streamName)) != null) {
            this.recordStream(stream, format, append, outputPath, versionFile, startOnKeyFrame, recordData);
        } else {
            ModuleLiveStreamRecord.getLogger().warn("ModuleStreamRecord.startRecording: stream not found: " + streamName);
        }
    }

    public String[] getRecorderNames() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.addAll(this.recorders.keySet());
        return retList.toArray(new String[retList.size()]);
    }

    public void getPublishStreamNames(IClient client, RequestFunction function, AMFDataList params) {
        AMFDataArray ret = new AMFDataArray();
        ModuleLiveStreamRecord.getLogger().info("ModuleStreamRecord.getPublishStreamNames");
        List namesList = client.getAppInstance().getPublishStreamNames();
        Iterator iter = namesList.iterator();
        int index = 0;
        while (iter.hasNext()) {
            String streamName = (String)iter.next();
            ret.add((AMFData)new AMFDataItem(streamName));
            ModuleLiveStreamRecord.getLogger().info("  publishName[" + index + "]: " + streamName);
            ++index;
        }
        ModuleLiveStreamRecord.sendResult((IClient)client, (AMFDataList)params, (AMFData)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stopRecording(String streamName) {
        ILiveStreamRecord recorder = null;
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            recorder = this.recorders.remove(streamName);
        }
        String outputPath = null;
        if (recorder != null) {
            outputPath = recorder.getFilePath();
            recorder.stopRecording();
        } else {
            ModuleLiveStreamRecord.getLogger().warn("ModuleStreamRecord.stopRecording: stream recorder not found: " + streamName);
        }
        return outputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording(IClient client, RequestFunction function, AMFDataList params) {
        String streamName = params.getString(3);
        ModuleLiveStreamRecord.getLogger().info("ModuleStreamRecord.stopRecording: " + streamName);
        ILiveStreamRecord recorder = null;
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            recorder = this.recorders.remove(streamName);
        }
        if (recorder != null) {
            String outputPath = recorder.getFilePath();
            recorder.stopRecording();
        } else {
            ModuleLiveStreamRecord.getLogger().warn("ModuleStreamRecord.stopRecording: stream recorder not found: " + streamName);
        }
    }

    public void onAppStart(IApplicationInstance appInstance) {
        this.appInstance = appInstance;
        ModuleLiveStreamRecord.getLogger().info("ModuleStreamRecord.onAppStart");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance appInstance) {
        ModuleLiveStreamRecord.getLogger().info("ModuleStreamRecord.onAppStop");
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            for (String streamName : this.recorders.keySet()) {
                ILiveStreamRecord recorder = this.recorders.get(streamName);
                recorder.stopRecording();
                ModuleLiveStreamRecord.getLogger().info("  stopRecording: " + streamName);
            }
            this.recorders.clear();
        }
    }
}

