/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoEncryptor;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHandler;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoRepeaterHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoTSHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoTSPacketizer;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.ICupertinoChunkWriter;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.media.mp3.model.idtags.ID3Frames;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerItem;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerCupertino
extends LiveStreamPacketizerBase
implements ICupertinoChunkWriter {
    public static final int STREAMMODE_TS = 1;
    public static final int STREAMMODE_MP3 = 2;
    public static final int STREAMMODE_AAC = 3;
    private int maxChunkCount = 10;
    private int maxChunkLogCount = 10;
    private int playlistChunkCount = 3;
    private int repeaterChunkCount = 3;
    private int chunkDurationTarget = 10000;
    private int chunkDurationTolerance = 500;
    private int audioGroupCount = 3;
    private int waitForCodecTime = 8000;
    private boolean forceH264BaselineProfile = false;
    private boolean createAudioOnlyRendition = false;
    private int forceAACProfile = -1;
    private boolean debugAACTimecodes = false;
    private boolean debugMP3Timecodes = false;
    private int maxSaveHolderSize = 500;
    private int maxChunkKeyCount = 50;
    private String cupertinoEncryptionBaseURL = null;
    private String cupertinoEncryptionLiveRepeaterSharedSecret = null;
    private boolean relativePlaylistItems = true;
    private boolean cupertinoDebugPacketizationOverhead = false;
    private String titleStr = "";
    private boolean allowCaching = false;
    private Object lock = new Object();
    private SortedMap<Integer, LiveStreamPacketizerCupertinoChunk> chunks = new TreeMap<Integer, LiveStreamPacketizerCupertinoChunk>();
    private SortedMap<Integer, LiveStreamPacketizerCupertinoChunk> chunksAudio = new TreeMap<Integer, LiveStreamPacketizerCupertinoChunk>();
    private int nextChunkId = 0;
    private int endChunkCount = 0;
    String playListStr = "#EXTM3U\n#EXT-X-ENDLIST";
    String codecsStr = null;
    String resolutionStr = null;
    String playListAudioStr = "#EXTM3U\n#EXT-X-ENDLIST";
    String codecsAudioStr = null;
    private Object playlistLock = new Object();
    private CupertinoEncInfo encInfo = null;
    private boolean encInfoRepeaterSet = false;
    private CupertinoTSPacketizer tsPacketizer = new CupertinoTSPacketizer();
    private CupertinoPacketHandler packetHandler = new CupertinoPacketHandler();
    private long repeaterSeq = 0L;
    private List<CupertinoRepeaterHolder> repeaterItems = new ArrayList<CupertinoRepeaterHolder>();
    private int streamMode = -1;
    private int videoCodec = -1;
    private int audioCodec = -1;
    private LiveStreamPacketizerCupertinoChunk pendingChunk = null;
    private LiveStreamPacketizerCupertinoChunk pendingAudioChunk = null;
    private MediaCodecInfoVideo lastCodecInfoVideo = null;
    private MediaCodecInfoAudio lastCodecInfoAudio = null;
    private MediaCodecInfoAudio lastCodecInfoAudioAudio = null;
    private CupertinoTSHolder pendingTS = null;
    private CupertinoTSHolder pendingAudioTS = null;
    private CupertinoEncryptor encryptor = null;
    private CupertinoEncryptor encryptorAudio = null;
    private List<CupertinoTSHolder> audioTSs = new ArrayList<CupertinoTSHolder>();
    private List<CupertinoTSHolder> videoTSs = new ArrayList<CupertinoTSHolder>();
    private BitrateCalculator calculatedBitrate = new BitrateCalculator();
    private BitrateCalculator calculatedBitrateAudio = new BitrateCalculator();
    private ID3Frames id3FramesHeader = new ID3Frames();
    private ID3Frames id3FramesFooter = new ID3Frames();
    private ID3Frames id3FramesHeaderAudio = new ID3Frames();
    private ID3Frames id3FramesFooterAudio = new ID3Frames();
    private ICupertinoChunkWriter chunkWriter = this;

    public LiveStreamPacketizerCupertino() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
    }

    public void init(String string, String string2, IApplicationInstance iApplicationInstance, LiveStreamPacketizerItem liveStreamPacketizerItem) {
        Object object;
        super.init(string, string2, iApplicationInstance, liveStreamPacketizerItem);
        WMSProperties wMSProperties = this.getProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        WMSProperties wMSProperties3 = iApplicationInstance.getHTTPStreamerProperties();
        this.titleStr = wMSProperties.getPropertyStr("cupertinoTitleStr", this.titleStr);
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean("cupertinoRelativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean("cupertinoRelativePlaylistItems", this.relativePlaylistItems);
        this.maxChunkCount = wMSProperties.getPropertyInt("maxChunkCount", this.maxChunkCount);
        this.maxChunkCount = wMSProperties.getPropertyInt("cupertinoMaxChunkCount", this.maxChunkCount);
        this.maxChunkLogCount = wMSProperties.getPropertyInt("maxChunkLogCount", this.maxChunkLogCount);
        this.maxChunkLogCount = wMSProperties.getPropertyInt("cupertinoMaxChunkLogCount", this.maxChunkLogCount);
        this.playlistChunkCount = wMSProperties.getPropertyInt("playlistChunkCount", this.playlistChunkCount);
        this.playlistChunkCount = wMSProperties.getPropertyInt("cupertinoPlaylistChunkCount", this.playlistChunkCount);
        this.repeaterChunkCount = wMSProperties.getPropertyInt("repeaterChunkCount", this.repeaterChunkCount);
        this.repeaterChunkCount = wMSProperties.getPropertyInt("cupertinoRepeaterChunkCount", this.repeaterChunkCount);
        this.chunkDurationTarget = wMSProperties.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
        this.chunkDurationTolerance = wMSProperties.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
        this.chunkDurationTolerance = wMSProperties.getPropertyInt("cupertinoChunkDurationTolerance", this.chunkDurationTolerance);
        this.waitForCodecTime = wMSProperties.getPropertyInt("waitForCodecTime", this.waitForCodecTime);
        this.waitForCodecTime = wMSProperties.getPropertyInt("cupertinoWaitForCodecTime", this.waitForCodecTime);
        this.maxSaveHolderSize = wMSProperties.getPropertyInt("maxSaveHolderSize", this.maxSaveHolderSize);
        this.maxSaveHolderSize = wMSProperties.getPropertyInt("cupertinoMaxSaveHolderSize", this.maxSaveHolderSize);
        this.maxChunkKeyCount = wMSProperties.getPropertyInt("maxChunkKeyCount", this.maxChunkKeyCount);
        this.maxChunkKeyCount = wMSProperties.getPropertyInt("cupertinoMaxChunkKeyCount", this.maxChunkKeyCount);
        this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("forceH264BaselineProfile", this.forceH264BaselineProfile);
        this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("cupertinoForceH264BaselineProfile", this.forceH264BaselineProfile);
        this.forceH264BaselineProfile = wMSProperties3.getPropertyBoolean("forceH264BaselineProfile", this.forceH264BaselineProfile);
        this.forceH264BaselineProfile = wMSProperties3.getPropertyBoolean("cupertinoForceH264BaselineProfile", this.forceH264BaselineProfile);
        this.createAudioOnlyRendition = wMSProperties.getPropertyBoolean("cupertinoCreateAudioOnlyRendition", this.createAudioOnlyRendition);
        this.createAudioOnlyRendition = wMSProperties3.getPropertyBoolean("cupertinoCreateAudioOnlyRendition", this.createAudioOnlyRendition);
        this.forceAACProfile = wMSProperties.getPropertyInt("forceAACProfile", this.forceAACProfile);
        this.forceAACProfile = wMSProperties.getPropertyInt("cupertinoForceAACProfile", this.forceAACProfile);
        this.debugAACTimecodes = wMSProperties.getPropertyBoolean("debugAACTimecodes", this.debugAACTimecodes);
        this.debugAACTimecodes = wMSProperties.getPropertyBoolean("cupertinoDebugAACTimecodes", this.debugAACTimecodes);
        this.debugMP3Timecodes = wMSProperties.getPropertyBoolean("debugMP3Timecodes", this.debugMP3Timecodes);
        this.debugMP3Timecodes = wMSProperties.getPropertyBoolean("cupertinoDebugMP3Timecodes", this.debugMP3Timecodes);
        this.cupertinoDebugPacketizationOverhead = wMSProperties.getPropertyBoolean("cupertinoDebugPacketizationOverhead", this.cupertinoDebugPacketizationOverhead);
        this.allowCaching = wMSProperties.getPropertyBoolean("allowCaching", this.allowCaching);
        this.allowCaching = wMSProperties.getPropertyBoolean("cupertinoAllowCaching", this.allowCaching);
        this.audioGroupCount = wMSProperties.getPropertyInt("audioGroupCount", this.audioGroupCount);
        this.audioGroupCount = wMSProperties.getPropertyInt("cupertinoAudioGroupCount", this.audioGroupCount);
        this.cupertinoEncryptionBaseURL = wMSProperties.getPropertyStr("cupertinoEncryptionBaseURL", this.cupertinoEncryptionBaseURL);
        this.cupertinoEncryptionBaseURL = wMSProperties2.getPropertyStr("cupertinoEncryptionBaseURL", this.cupertinoEncryptionBaseURL);
        this.cupertinoEncryptionLiveRepeaterSharedSecret = wMSProperties.getPropertyStr("cupertinoEncryptionLiveRepeaterSharedSecret", this.cupertinoEncryptionLiveRepeaterSharedSecret);
        this.cupertinoEncryptionLiveRepeaterSharedSecret = wMSProperties2.getPropertyStr("cupertinoEncryptionLiveRepeaterSharedSecret", this.cupertinoEncryptionLiveRepeaterSharedSecret);
        this.initPacketHandler();
        this.tsPacketizer.setForceH264BaselineProfile(this.forceH264BaselineProfile);
        this.tsPacketizer.setForceAACProfile(this.forceAACProfile);
        String string3 = this.getContextStr();
        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: chunkDurationTarget: " + this.chunkDurationTarget);
        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: chunkDurationTolerance: " + this.chunkDurationTolerance);
        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: audioGroupCount: " + this.audioGroupCount);
        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: playlistChunkCount:" + this.playlistChunkCount);
        if (this.forceH264BaselineProfile) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: Forcing H.264 profile to Baseline level 3.0");
        }
        if (this.forceAACProfile >= 0) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: Forcing AAC profile to " + AACUtils.profileObjectTypeToString((int)this.forceAACProfile));
        }
        if (this.cupertinoEncryptionBaseURL != null) {
            object = iApplicationInstance.getVHost().getHTTPStreamerContext();
            byte[] byArray = object.getEncKey(iApplicationInstance, string);
            if (byArray != null) {
                iApplicationInstance.getModFunctions().onHTTPCupertinoEncryptionKeyCreateLive(iApplicationInstance, string, byArray);
                String string4 = this.cupertinoEncryptionBaseURL;
                if (!string4.endsWith("/")) {
                    string4 = string4 + "/";
                }
                string4 = string4 + iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName() + "/" + string + "/key.m3u8key";
                this.encInfo = new CupertinoEncInfo(BufferUtils.encodeHexString((byte[])byArray), byArray, string4);
                this.encInfo.setInternal(true);
            }
        } else {
            this.encInfo = LiveStreamPacketizerCupertinoUtils.getEncInfo(iApplicationInstance, string);
        }
        if (this.encInfo != null) {
            object = null;
            if (this.cupertinoEncryptionLiveRepeaterSharedSecret != null) {
                object = CupertinoEncInfo.encryptionKeyToRepeaterKey(this.encInfo.getEncKeyBytes(), this.cupertinoEncryptionLiveRepeaterSharedSecret);
            }
            if (object != null) {
                this.encInfo.setEncRepeaterBytes((byte[])object);
            }
            if (this.encInfo.getEncKey() != null) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: Encrypt Cupertino stream: key: *" + this.encInfo.getEncKey().substring(28));
            }
            if (this.encInfo.getEncUrl() != null) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.init[" + string3 + "]: Encrypt Cupertino stream: url: " + this.encInfo.getEncUrl());
            }
        }
    }

    private void initPacketHandler() {
        this.packetHandler.setChunkWriter(this.chunkWriter);
        this.packetHandler.setAudioGroupCount(this.audioGroupCount);
        this.packetHandler.setWaitForCodecTime(this.waitForCodecTime);
        this.packetHandler.setChunkDurationTarget(this.chunkDurationTarget);
        this.packetHandler.setChunkDurationTolerance(this.chunkDurationTolerance);
        this.packetHandler.setDebugAACTimecodes(this.debugAACTimecodes);
        this.packetHandler.setDebugMP3Timecodes(this.debugMP3Timecodes);
        this.packetHandler.setMaxSaveHolderSize(this.maxSaveHolderSize);
        this.packetHandler.setMaxChunkKeyCount(this.maxChunkKeyCount);
    }

    public byte[] getEncryptionKeyBytes() {
        return this.encInfo == null ? null : this.encInfo.getEncKeyBytes();
    }

    public String getEncryptionURL() {
        return this.encInfo == null ? null : this.encInfo.getEncUrl();
    }

    public CupertinoEncInfo getEncryptionInfo() {
        return this.encInfo;
    }

    public void internalStartStream(IMediaStream iMediaStream) {
        this.packetHandler.startStream(iMediaStream);
    }

    public void internalResetStream(IMediaStream iMediaStream) {
        WMSLoggerFactory.getLogger(CupertinoPacketHandler.class).info("CupertinoPacketHandler.resetStream[" + iMediaStream.getContextStr() + "]");
        this.packetHandler = new CupertinoPacketHandler();
        this.initPacketHandler();
        this.resetStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStream() {
        this.pendingChunk = null;
        this.pendingAudioChunk = null;
        this.pendingTS = null;
        this.pendingAudioTS = null;
        this.audioTSs.clear();
        this.videoTSs.clear();
        this.lastCodecInfoVideo = null;
        this.lastCodecInfoAudio = null;
        this.lastCodecInfoAudioAudio = null;
        if (this.encryptor != null) {
            this.encryptor.close();
        }
        this.encryptor = null;
        if (this.encryptorAudio != null) {
            this.encryptorAudio.close();
        }
        this.encryptorAudio = null;
        Object object = this.lock;
        synchronized (object) {
            this.chunks.clear();
            this.chunksAudio.clear();
            this.updatePlaylistStr();
        }
        object = this.lock;
        synchronized (object) {
            CupertinoRepeaterHolder cupertinoRepeaterHolder;
            boolean bl = true;
            int n = this.repeaterItems.size();
            if (n > 0 && (cupertinoRepeaterHolder = this.repeaterItems.get(n - 1)).getRepeaterType() == 4) {
                bl = false;
            }
            if (bl) {
                cupertinoRepeaterHolder = new CupertinoRepeaterHolder(this.repeaterSeq);
                ++this.repeaterSeq;
                this.repeaterItems.add(cupertinoRepeaterHolder);
            }
        }
    }

    public void internalHandlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        this.touch(l);
        this.packetHandler.handlePacket(iMediaStream, aMFPacket);
    }

    @Override
    public void startChunk(int n, int n2, int n3, long l) {
        CupertinoTSHolder cupertinoTSHolder;
        ++this.nextChunkId;
        this.streamMode = n;
        this.videoCodec = n2;
        this.audioCodec = n3;
        String string = "";
        byte[] byArray = null;
        if (this.encInfo != null) {
            string = this.encInfo.getEncUrl();
            byArray = this.encInfo.getEncRepeaterBytes();
        }
        this.startChunkTS(this.nextChunkId, false, n, n2, n3, l, string, byArray);
        if (this.createAudioOnlyRendition) {
            int n4 = this.audioCodec == 2 ? 2 : 3;
            this.startChunkAudioTS(this.nextChunkId, false, n4, n2, n3, l, string, byArray);
        }
        if (this.encInfo != null) {
            this.encryptor = new CupertinoEncryptor();
            this.encryptor.init(this.encInfo, this.nextChunkId);
            if (this.createAudioOnlyRendition) {
                this.encryptorAudio = new CupertinoEncryptor();
                this.encryptorAudio.init(this.encInfo, this.nextChunkId);
            }
        }
        if (n == 1) {
            byte[] byArray2 = this.tsPacketizer.getTSHeader(7, this.audioCodec);
            cupertinoTSHolder = new CupertinoTSHolder(18, -1, byArray2, 0, byArray2.length, l, l * 90L);
            this.sortTS(cupertinoTSHolder, false);
        } else if (n == 3 || n == 2) {
            byte[] byArray3 = this.tsPacketizer.getAudioID3TagHeader(l * 90L);
            cupertinoTSHolder = new CupertinoTSHolder(18, -1, byArray3, 0, byArray3.length, l, l * 90L);
            this.sortTS(cupertinoTSHolder, false);
        }
        if (!this.id3FramesHeader.isEmpty()) {
            byte[] byArray4 = this.id3FramesHeader.serialize(true, true, 0);
            cupertinoTSHolder = new CupertinoTSHolder(18, -1, byArray4, 0, byArray4.length, l, l * 90L);
            this.sortTS(cupertinoTSHolder, false);
        }
        if (this.createAudioOnlyRendition) {
            byte[] byArray5 = this.tsPacketizer.getAudioID3TagHeader(l * 90L);
            cupertinoTSHolder = new CupertinoTSHolder(18, -1, byArray5, 0, byArray5.length, l, l * 90L);
            this.sortAudioTS(cupertinoTSHolder, false);
            if (!this.id3FramesHeaderAudio.isEmpty()) {
                byte[] byArray6 = this.id3FramesHeaderAudio.serialize(true, true, 0);
                cupertinoTSHolder = new CupertinoTSHolder(18, -1, byArray6, 0, byArray6.length, l, l * 90L);
                this.sortAudioTS(cupertinoTSHolder, false);
            }
        }
    }

    @Override
    public void endChunk(long l) {
        CupertinoTSHolder cupertinoTSHolder;
        byte[] byArray;
        if (!this.id3FramesFooter.isEmpty()) {
            byArray = this.id3FramesFooter.serialize(true, true, 0);
            cupertinoTSHolder = new CupertinoTSHolder(18, -1, byArray, 0, byArray.length, l, l * 90L);
            this.sortTS(cupertinoTSHolder, false);
        }
        if (this.createAudioOnlyRendition && !this.id3FramesFooterAudio.isEmpty()) {
            byArray = this.id3FramesFooterAudio.serialize(true, true, 0);
            cupertinoTSHolder = new CupertinoTSHolder(18, -1, byArray, 0, byArray.length, l, l * 90L);
            this.sortAudioTS(cupertinoTSHolder, false);
        }
        this.sortTS(null, true);
        this.sortAudioTS(null, true);
        this.endChunkTS(l);
        if (this.createAudioOnlyRendition) {
            this.endChunkAudioTS(l);
        }
        if (this.encryptor != null) {
            this.encryptor.close();
        }
        this.encryptor = null;
        if (this.createAudioOnlyRendition) {
            if (this.encryptorAudio != null) {
                this.encryptorAudio.close();
            }
            this.encryptorAudio = null;
        }
    }

    public void sortAudioTS(CupertinoTSHolder cupertinoTSHolder, boolean bl) {
        if (cupertinoTSHolder != null) {
            this.encryptAudioTS(cupertinoTSHolder);
        }
    }

    public void sortTS(CupertinoTSHolder cupertinoTSHolder, boolean bl) {
        if (this.videoCodec != -1 && this.audioCodec != -1) {
            if (cupertinoTSHolder != null) {
                switch (cupertinoTSHolder.getType()) {
                    case 8: {
                        this.audioTSs.add(cupertinoTSHolder);
                        break;
                    }
                    case 9: {
                        this.videoTSs.add(cupertinoTSHolder);
                        break;
                    }
                    default: {
                        this.encryptTS(cupertinoTSHolder);
                    }
                }
            }
            boolean bl2 = true;
            if (bl) {
                if (this.audioTSs.size() <= 0 && this.videoTSs.size() <= 0) {
                    bl2 = false;
                }
            } else if (this.audioTSs.size() <= 0 || this.videoTSs.size() <= 0) {
                bl2 = false;
            }
            while (bl2) {
                long l;
                long l2 = this.audioTSs.size() > 0 ? this.audioTSs.get(0).getTimecode() : Long.MAX_VALUE;
                long l3 = l = this.videoTSs.size() > 0 ? this.videoTSs.get(0).getTimecode() : Long.MAX_VALUE;
                if (l < l2) {
                    cupertinoTSHolder = this.videoTSs.remove(0);
                    this.encryptTS(cupertinoTSHolder);
                } else {
                    cupertinoTSHolder = this.audioTSs.remove(0);
                    this.encryptTS(cupertinoTSHolder);
                }
                if (!(bl ? this.audioTSs.size() <= 0 && this.videoTSs.size() <= 0 : this.audioTSs.size() <= 0 || this.videoTSs.size() <= 0)) continue;
                break;
            }
        } else if (cupertinoTSHolder != null) {
            this.encryptTS(cupertinoTSHolder);
        }
        if (bl) {
            this.encryptTS(null);
        }
    }

    public void encryptTS(CupertinoTSHolder cupertinoTSHolder) {
        if (this.pendingTS != null) {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2;
            if (this.encryptor != null && (byArray2 = this.encryptor.encryptChunk(byArray = this.pendingTS.getBlock(), n2 = this.pendingTS.getOffset(), n = this.pendingTS.getLen(), cupertinoTSHolder == null)) != null) {
                this.pendingTS.setBlock(byArray2);
                this.pendingTS.setOffset(0);
                this.pendingTS.setLen(byArray2.length);
            }
            this.addToChunkTS(this.pendingTS);
            this.pendingTS = null;
        }
        this.pendingTS = cupertinoTSHolder;
    }

    public void encryptAudioTS(CupertinoTSHolder cupertinoTSHolder) {
        if (this.pendingAudioTS != null) {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2;
            if (this.encryptorAudio != null && (byArray2 = this.encryptorAudio.encryptChunk(byArray = this.pendingAudioTS.getBlock(), n2 = this.pendingAudioTS.getOffset(), n = this.pendingAudioTS.getLen(), cupertinoTSHolder == null)) != null) {
                this.pendingAudioTS.setBlock(byArray2);
                this.pendingAudioTS.setOffset(0);
                this.pendingAudioTS.setLen(byArray2.length);
            }
            this.addToChunkAudioTS(this.pendingAudioTS);
            this.pendingAudioTS = null;
        }
        this.pendingAudioTS = cupertinoTSHolder;
    }

    @Override
    public void addToChunk(CupertinoPacketHolder cupertinoPacketHolder) {
        CupertinoTSHolder cupertinoTSHolder = null;
        CupertinoTSHolder cupertinoTSHolder2 = null;
        if (cupertinoPacketHolder.getType() == 8) {
            byte[] byArray = null;
            byArray = this.streamMode == 2 ? this.tsPacketizer.audioPacketsToMP3(cupertinoPacketHolder.getHolders()) : (this.streamMode == 3 ? this.tsPacketizer.audioPacketsToAAC(cupertinoPacketHolder.getHolders()) : this.tsPacketizer.audioPacketsToTS(cupertinoPacketHolder.getHolders()));
            if (byArray != null) {
                cupertinoTSHolder = new CupertinoTSHolder(8, cupertinoPacketHolder.getCodec(), byArray, 0, byArray.length, cupertinoPacketHolder.getTimecode(), cupertinoPacketHolder.getTimecode90());
                cupertinoTSHolder.setDataLen(cupertinoPacketHolder.getDataLen());
            }
            if (this.createAudioOnlyRendition) {
                byte[] byArray2 = null;
                if (cupertinoPacketHolder.getCodec() == 2) {
                    byArray2 = this.tsPacketizer.audioPacketsToMP3(cupertinoPacketHolder.getHolders());
                } else if (cupertinoPacketHolder.getCodec() == 10) {
                    byArray2 = this.tsPacketizer.audioPacketsToAAC(cupertinoPacketHolder.getHolders());
                }
                if (byArray2 != null) {
                    cupertinoTSHolder2 = new CupertinoTSHolder(8, cupertinoPacketHolder.getCodec(), byArray2, 0, byArray2.length, cupertinoPacketHolder.getTimecode(), cupertinoPacketHolder.getTimecode90());
                    cupertinoTSHolder2.setDataLen(cupertinoPacketHolder.getDataLen());
                }
            }
        } else if (cupertinoPacketHolder.getType() == 9) {
            if (cupertinoPacketHolder.isCodecConfig()) {
                this.tsPacketizer.videoCodecConfigIngest(cupertinoPacketHolder.getPacket());
            } else {
                byte[] byArray = this.tsPacketizer.videoPacketToTS(cupertinoPacketHolder);
                if (byArray != null) {
                    cupertinoTSHolder = new CupertinoTSHolder(9, cupertinoPacketHolder.getCodec(), byArray, 0, byArray.length, cupertinoPacketHolder.getTimecode(), cupertinoPacketHolder.getTimecode90());
                    cupertinoTSHolder.setDataLen(cupertinoPacketHolder.getDataLen());
                    cupertinoTSHolder.setKey(cupertinoPacketHolder.isKey());
                }
            }
        } else if (cupertinoPacketHolder.getType() == 18) {
            // empty if block
        }
        if (cupertinoTSHolder != null) {
            this.sortTS(cupertinoTSHolder, false);
        }
        if (cupertinoTSHolder2 != null) {
            this.sortAudioTS(cupertinoTSHolder2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCodecInfoAudio(MediaCodecInfoAudio mediaCodecInfoAudio) {
        long l = System.currentTimeMillis();
        this.touch(l);
        if (this.pendingAudioChunk != null) {
            this.pendingAudioChunk.setCodecInfoAudio(mediaCodecInfoAudio);
        }
        if (this.pendingChunk != null) {
            this.pendingChunk.setCodecInfoAudio(mediaCodecInfoAudio);
        }
        CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder(this.repeaterSeq);
        cupertinoRepeaterHolder.setRepeaterType(6);
        cupertinoRepeaterHolder.setCodecInfoAudio(mediaCodecInfoAudio);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(cupertinoRepeaterHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCodecInfoVideo(MediaCodecInfoVideo mediaCodecInfoVideo) {
        long l = System.currentTimeMillis();
        this.touch(l);
        if (this.pendingAudioChunk != null) {
            this.pendingAudioChunk.setCodecInfoVideo(mediaCodecInfoVideo);
        }
        if (this.pendingChunk != null) {
            this.pendingChunk.setCodecInfoVideo(mediaCodecInfoVideo);
        }
        CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder(this.repeaterSeq);
        cupertinoRepeaterHolder.setRepeaterType(5);
        cupertinoRepeaterHolder.setCodecInfoVideo(mediaCodecInfoVideo);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(cupertinoRepeaterHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startChunkAudioTS(int n, boolean bl, int n2, int n3, int n4, long l, String string, byte[] byArray) {
        Object object;
        long l2 = System.currentTimeMillis();
        this.touch(l2);
        if (bl && !this.encInfoRepeaterSet) {
            if (byArray != null && this.cupertinoEncryptionLiveRepeaterSharedSecret != null && this.encInfo != null && (object = CupertinoEncInfo.repeaterKeyToEncryptionKey(byArray, this.cupertinoEncryptionLiveRepeaterSharedSecret)) != null) {
                this.encInfo.setEncKeyBytes((byte[])object);
                this.encInfo.setEncKey(BufferUtils.encodeHexString((byte[])object));
                this.encInfo.setEncRepeaterBytes(byArray);
            }
            this.encInfoRepeaterSet = true;
        }
        this.pendingAudioChunk = new LiveStreamPacketizerCupertinoChunk(n);
        this.pendingAudioChunk.setStartTimecode(l);
        this.pendingAudioChunk.setCacheable(this.allowCaching);
        this.pendingAudioChunk.setEncUrl(string);
        this.pendingAudioChunk.setEncRepeaterBytes(byArray);
        this.pendingAudioChunk.setStreamMode(n2);
        object = new CupertinoRepeaterHolder(this.repeaterSeq, n, n2, n3, n4, string, l, byArray);
        ((CupertinoRepeaterHolder)object).setRepeaterType(11);
        ++this.repeaterSeq;
        Object object2 = this.lock;
        synchronized (object2) {
            this.repeaterItems.add((CupertinoRepeaterHolder)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startChunkTS(int n, boolean bl, int n2, int n3, int n4, long l, String string, byte[] byArray) {
        Object object;
        long l2 = System.currentTimeMillis();
        this.touch(l2);
        if (bl && !this.encInfoRepeaterSet) {
            if (byArray != null && this.cupertinoEncryptionLiveRepeaterSharedSecret != null && this.encInfo != null && (object = CupertinoEncInfo.repeaterKeyToEncryptionKey(byArray, this.cupertinoEncryptionLiveRepeaterSharedSecret)) != null) {
                this.encInfo.setEncKeyBytes((byte[])object);
                this.encInfo.setEncKey(BufferUtils.encodeHexString((byte[])object));
                this.encInfo.setEncRepeaterBytes(byArray);
            }
            this.encInfoRepeaterSet = true;
        }
        this.pendingChunk = new LiveStreamPacketizerCupertinoChunk(n);
        this.pendingChunk.setStartTimecode(l);
        this.pendingChunk.setCacheable(this.allowCaching);
        this.pendingChunk.setEncUrl(string);
        this.pendingChunk.setEncRepeaterBytes(byArray);
        this.pendingChunk.setStreamMode(n2);
        object = new CupertinoRepeaterHolder(this.repeaterSeq, n, n2, n3, n4, string, l, byArray);
        ++this.repeaterSeq;
        Object object2 = this.lock;
        synchronized (object2) {
            this.repeaterItems.add((CupertinoRepeaterHolder)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endChunkAudioTS(long l) {
        block18: {
            long l2 = System.currentTimeMillis();
            this.touch(l2);
            try {
                if (this.pendingAudioChunk == null) break block18;
                CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder(this.repeaterSeq, this.pendingAudioChunk.getChunkIndex(), l);
                cupertinoRepeaterHolder.setRepeaterType(12);
                ++this.repeaterSeq;
                Object object = this.lock;
                synchronized (object) {
                    this.repeaterItems.add(cupertinoRepeaterHolder);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.endChunkAudioTS[" + this.getContextStr() + ",1]: " + exception.toString());
            }
        }
        long l3 = 0L;
        try {
            if (this.pendingAudioChunk != null) {
                l3 = l - this.pendingAudioChunk.getStartTimecode();
                boolean bl = false;
                if (this.lastCodecInfoAudioAudio != null && this.pendingAudioChunk.getCodecInfoAudio() != null && !this.lastCodecInfoAudioAudio.equals(this.pendingAudioChunk.getCodecInfoAudio())) {
                    bl = true;
                }
                this.lastCodecInfoAudioAudio = this.pendingAudioChunk.getCodecInfoAudio();
                this.pendingAudioChunk.setNewCodecInfo(bl);
                this.pendingAudioChunk.setDuration(l3);
                if (this.maxChunkLogCount == 0 || this.pendingAudioChunk.getChunkIndex() <= this.maxChunkLogCount) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.endChunkAudioTS[" + this.getContextStr() + "]: Add chunk: id:" + this.pendingAudioChunk.getChunkIndex() + " a:" + this.pendingAudioChunk.getAudioCount() + " duration:" + l3);
                }
                if (this.cupertinoDebugPacketizationOverhead) {
                    long l4 = 0L;
                    long l5 = this.pendingAudioChunk.getDataSize();
                    List<LiveStreamingCupertinoBlock> list = this.pendingAudioChunk.getBlockList();
                    for (LiveStreamingCupertinoBlock liveStreamingCupertinoBlock : list) {
                        l4 += (long)liveStreamingCupertinoBlock.getLen();
                    }
                    long l6 = (l4 - l5) * 10000L / l5;
                    double d = (double)l6 / 100.0;
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.endChunkAudioTS[" + this.getContextStr() + "]: id:" + this.pendingAudioChunk.getChunkIndex() + " overhead[" + l4 + ":" + l5 + "]:" + d + "%");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.endChunkAudioTS[" + this.getContextStr() + ",2]: " + exception.toString());
        }
        try {
            int n = this.nextChunkId;
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingAudioChunk != null) {
                    this.calculatedBitrateAudio.addChunk(this.pendingAudioChunk.getSize(), l3);
                    this.chunksAudio.put(this.pendingAudioChunk.getChunkIndex(), this.pendingAudioChunk);
                    n = this.pendingAudioChunk.getChunkIndex();
                }
                this.trimAudio(n);
                this.updateAudioPlaylistStr();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.endChunkAudioTS3[" + this.getContextStr() + ",3]: " + exception.toString());
        }
        this.pendingAudioChunk = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endChunkTS(long l) {
        block19: {
            long l2 = System.currentTimeMillis();
            this.touch(l2);
            try {
                if (this.pendingChunk == null) break block19;
                CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder(this.repeaterSeq, this.pendingChunk.getChunkIndex(), l);
                ++this.repeaterSeq;
                Object object = this.lock;
                synchronized (object) {
                    this.repeaterItems.add(cupertinoRepeaterHolder);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.endChunkTS[" + this.getContextStr() + ",1]: " + exception.toString());
            }
        }
        long l3 = 0L;
        try {
            if (this.pendingChunk != null) {
                l3 = l - this.pendingChunk.getStartTimecode();
                boolean bl = false;
                if (this.lastCodecInfoAudio != null && this.pendingChunk.getCodecInfoAudio() != null && !this.lastCodecInfoAudio.equals(this.pendingChunk.getCodecInfoAudio())) {
                    bl = true;
                }
                if (this.lastCodecInfoVideo != null && this.pendingChunk.getCodecInfoVideo() != null && !this.lastCodecInfoVideo.equals(this.pendingChunk.getCodecInfoVideo())) {
                    bl = true;
                }
                this.lastCodecInfoAudio = this.pendingChunk.getCodecInfoAudio();
                this.lastCodecInfoVideo = this.pendingChunk.getCodecInfoVideo();
                this.pendingChunk.setNewCodecInfo(bl);
                this.pendingChunk.setDuration(l3);
                if (this.maxChunkLogCount == 0 || this.pendingChunk.getChunkIndex() <= this.maxChunkLogCount) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.endChunkTS[" + this.getContextStr() + "]: Add chunk: id:" + this.pendingChunk.getChunkIndex() + " a/v/k:" + this.pendingChunk.getAudioCount() + "/" + this.pendingChunk.getVideoCount() + "/" + this.pendingChunk.getVideoKeyCount() + " duration:" + l3);
                }
                if (this.cupertinoDebugPacketizationOverhead) {
                    long l4 = 0L;
                    long l5 = this.pendingChunk.getDataSize();
                    List<LiveStreamingCupertinoBlock> list = this.pendingChunk.getBlockList();
                    for (LiveStreamingCupertinoBlock liveStreamingCupertinoBlock : list) {
                        l4 += (long)liveStreamingCupertinoBlock.getLen();
                    }
                    long l6 = (l4 - l5) * 10000L / l5;
                    double d = (double)l6 / 100.0;
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.endChunkTS[" + this.getContextStr() + "]: id:" + this.pendingChunk.getChunkIndex() + " overhead[" + l4 + ":" + l5 + "]:" + d + "%");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.endChunkTS[" + this.getContextStr() + ",2]: " + exception.toString());
        }
        try {
            int n = this.nextChunkId;
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingChunk != null) {
                    this.calculatedBitrate.addChunk(this.pendingChunk.getSize(), l3);
                    this.chunks.put(this.pendingChunk.getChunkIndex(), this.pendingChunk);
                    n = this.pendingChunk.getChunkIndex();
                }
                this.trim(n);
                this.updatePlaylistStr();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.endChunkTS[" + this.getContextStr() + ",3]: " + exception.toString());
        }
        ++this.endChunkCount;
        this.pendingChunk = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToChunkAudioTS(CupertinoTSHolder cupertinoTSHolder) {
        long l = System.currentTimeMillis();
        this.touch(l);
        CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder(this.repeaterSeq, this.pendingAudioChunk.getChunkIndex(), cupertinoTSHolder);
        cupertinoRepeaterHolder.setRepeaterType(13);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(cupertinoRepeaterHolder);
        }
        if (this.pendingAudioChunk != null) {
            object = cupertinoTSHolder.getBlock();
            switch (cupertinoTSHolder.getType()) {
                case 8: {
                    this.pendingAudioChunk.incAudioCount();
                    break;
                }
                case 9: {
                    this.pendingAudioChunk.incVideoCount();
                    if (!cupertinoTSHolder.isKey()) break;
                    this.pendingAudioChunk.incVideoKeyCount();
                }
            }
            this.pendingAudioChunk.addBlock((byte[])object, cupertinoTSHolder.getOffset(), cupertinoTSHolder.getLen());
            this.pendingAudioChunk.incDataSize(cupertinoTSHolder.getDataLen());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToChunkTS(CupertinoTSHolder cupertinoTSHolder) {
        long l = System.currentTimeMillis();
        this.touch(l);
        CupertinoRepeaterHolder cupertinoRepeaterHolder = new CupertinoRepeaterHolder(this.repeaterSeq, this.pendingChunk.getChunkIndex(), cupertinoTSHolder);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(cupertinoRepeaterHolder);
        }
        if (this.pendingChunk != null) {
            object = cupertinoTSHolder.getBlock();
            switch (cupertinoTSHolder.getType()) {
                case 8: {
                    this.pendingChunk.incAudioCount();
                    break;
                }
                case 9: {
                    this.pendingChunk.incVideoCount();
                    if (!cupertinoTSHolder.isKey()) break;
                    this.pendingChunk.incVideoKeyCount();
                }
            }
            this.pendingChunk.addBlock((byte[])object, cupertinoTSHolder.getOffset(), cupertinoTSHolder.getLen());
            this.pendingChunk.incDataSize(cupertinoTSHolder.getDataLen());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRepeaterLastSeqence() {
        long l = -1L;
        Object object = this.lock;
        synchronized (object) {
            int n = this.repeaterItems.size();
            if (n > 0) {
                l = this.repeaterItems.get(n - 1).getSequence();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRepeaterItems(List<CupertinoRepeaterHolder> list, long l) {
        Object object = this.lock;
        synchronized (object) {
            if (l < 0L) {
                list.addAll(this.repeaterItems);
            } else {
                long l2;
                int n;
                int n2 = this.repeaterItems.size();
                if (n2 > 0 && (n = (int)(l - (l2 = this.repeaterItems.get(0).getSequence()))) >= 0) {
                    for (int i = n; i < n2; ++i) {
                        list.add(this.repeaterItems.get(i));
                    }
                }
            }
        }
    }

    private void trimAudio(int n) {
        while (this.chunksAudio.size() > this.maxChunkCount) {
            this.chunksAudio.remove(this.chunksAudio.firstKey());
        }
    }

    private void trim(int n) {
        CupertinoRepeaterHolder cupertinoRepeaterHolder;
        while (this.chunks.size() > this.maxChunkCount) {
            this.chunks.remove(this.chunks.firstKey());
        }
        for (int i = this.repeaterItems.size(); i > 0 && (cupertinoRepeaterHolder = this.repeaterItems.get(0)).getChunkId() < n - this.repeaterChunkCount; --i) {
            this.repeaterItems.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveStreamPacketizerCupertinoChunk getChunkByFilename(String string) {
        LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk;
        block5: {
            liveStreamPacketizerCupertinoChunk = null;
            try {
                int n = LiveStreamPacketizerCupertinoUtils.chunkFilenameToIndex(string);
                if (n < 0) break block5;
                Object object = this.lock;
                synchronized (object) {
                    liveStreamPacketizerCupertinoChunk = (LiveStreamPacketizerCupertinoChunk)this.chunks.get(new Integer(n));
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.getChunkByFilename: " + exception.toString());
            }
        }
        return liveStreamPacketizerCupertinoChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveStreamPacketizerCupertinoChunk getChunkAudioByFilename(String string) {
        LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk;
        block5: {
            liveStreamPacketizerCupertinoChunk = null;
            try {
                int n = LiveStreamPacketizerCupertinoUtils.chunkFilenameToIndex(string);
                if (n < 0) break block5;
                Object object = this.lock;
                synchronized (object) {
                    liveStreamPacketizerCupertinoChunk = (LiveStreamPacketizerCupertinoChunk)this.chunksAudio.get(new Integer(n));
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.getChunkAudioByFilename: " + exception.toString());
            }
        }
        return liveStreamPacketizerCupertinoChunk;
    }

    public Object getPlaylistLock() {
        return this.playlistLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlaylistStr() {
        Object object = this.playlistLock;
        synchronized (object) {
            return this.playListStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodecsStr() {
        Object object = this.playlistLock;
        synchronized (object) {
            return this.codecsStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResolutionStr() {
        Object object = this.playlistLock;
        synchronized (object) {
            return this.resolutionStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlaylistAudioStr() {
        Object object = this.playlistLock;
        synchronized (object) {
            return this.playListAudioStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodecsAudioStr() {
        Object object = this.playlistLock;
        synchronized (object) {
            return this.codecsAudioStr;
        }
    }

    private int millisToSecondsDuration(long l) {
        int n = (int)Math.round((double)l / 1000.0);
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptyPlaylist() {
        Object object = this.playlistLock;
        synchronized (object) {
            return this.playListStr.equals("#EXTM3U\n#EXT-X-ENDLIST");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmptyAudioPlaylist() {
        Object object = this.playlistLock;
        synchronized (object) {
            return this.playListAudioStr.equals("#EXTM3U\n#EXT-X-ENDLIST");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAudioPlaylistStr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#EXTM3U\n#EXT-X-ENDLIST");
        String string = null;
        try {
            int n = this.chunksAudio.size();
            if (n > 0) {
                int n2 = n - this.playlistChunkCount;
                if (n2 < 0) {
                    n2 = 0;
                }
                stringBuffer.setLength(0);
                LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = (LiveStreamPacketizerCupertinoChunk)this.chunksAudio.get(this.chunksAudio.firstKey());
                int n3 = liveStreamPacketizerCupertinoChunk.getChunkIndex();
                LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk2 = (LiveStreamPacketizerCupertinoChunk)this.chunksAudio.get(new Integer(n3 + n2));
                stringBuffer.append("#EXTM3U\n");
                stringBuffer.append("#EXT-X-ALLOW-CACHE:" + (this.allowCaching ? "YES" : "NO") + "\n");
                stringBuffer.append("#EXT-X-TARGETDURATION:" + this.millisToSecondsDuration(this.chunkDurationTarget) + "\n");
                stringBuffer.append("#EXT-X-MEDIA-SEQUENCE:" + liveStreamPacketizerCupertinoChunk2.getChunkIndex() + "\n");
                Object object = "";
                for (int i = n2; i < n; ++i) {
                    String string2;
                    Object object2;
                    LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk3 = (LiveStreamPacketizerCupertinoChunk)this.chunksAudio.get(new Integer(n3 + i));
                    if (string == null) {
                        object2 = liveStreamPacketizerCupertinoChunk3.getCodecInfoAudio();
                        string = this.codecInfoAudioToCodecsStr((MediaCodecInfoAudio)object2);
                    }
                    if ((object2 = liveStreamPacketizerCupertinoChunk3.getEncUrl()) != null && ((String)object2).length() > 0 && !((String)object).equalsIgnoreCase((String)object2)) {
                        string2 = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"".replace("{encmethod}", "AES-128");
                        String string3 = "?";
                        if (((String)object2).indexOf("?") >= 0) {
                            string3 = "&";
                        }
                        string2 = string2.replace("{enckeyurl}", (String)object2 + string3 + "{query}");
                        stringBuffer.append(string2 + "\n");
                        object = object2;
                    }
                    string2 = this.relativePlaylistItems ? "{filename}?{query}" : "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
                    stringBuffer.append("#EXTINF:" + this.millisToSecondsDuration(liveStreamPacketizerCupertinoChunk3.getDuration()) + "," + this.titleStr + "\n");
                    stringBuffer.append(string2.replace("{filename}", "media_{index}{ext}".replace("{index}", liveStreamPacketizerCupertinoChunk3.getChunkIndex() + "")).replace("{ext}", LiveStreamPacketizerCupertinoUtils.streamModeToFileExtension(liveStreamPacketizerCupertinoChunk3.getStreamMode())) + "\n");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.updatePlaylistStr: " + exception.toString());
            exception.printStackTrace();
        }
        Object object = this.playlistLock;
        synchronized (object) {
            this.codecsAudioStr = string;
            this.playListAudioStr = stringBuffer.toString();
        }
    }

    private String codecInfoAudioToCodecsStr(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio != null) {
            switch (mediaCodecInfoAudio.getCodecId()) {
                case 10: {
                    if (mediaCodecInfoAudio.getAudioObjectType() <= 0) break;
                    string = "mp4a.40." + mediaCodecInfoAudio.getAudioObjectType();
                    break;
                }
                case 2: {
                    string = "mp4a.40.34";
                }
            }
        }
        return string;
    }

    private String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo != null) {
            switch (mediaCodecInfoVideo.getCodecId()) {
                case 7: {
                    if (this.forceH264BaselineProfile) {
                        string = "avc1.66.30";
                        break;
                    }
                    int n = mediaCodecInfoVideo.getVideoLevel();
                    int n2 = mediaCodecInfoVideo.getVideoProfile();
                    if (n <= 0 || n2 <= 0) break;
                    string = "avc1." + n2 + "." + n;
                }
            }
        }
        return string;
    }

    private String codecInfoVideoToResolutionStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo != null) {
            int n = mediaCodecInfoVideo.getDisplayWidth();
            int n2 = mediaCodecInfoVideo.getDisplayHeight();
            if (n > 0 && n2 > 0) {
                string = n + "x" + n2;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlaylistStr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#EXTM3U\n#EXT-X-ENDLIST");
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            int n = this.chunks.size();
            if (n > 0) {
                int n2 = n - this.playlistChunkCount;
                if (n2 < 0) {
                    n2 = 0;
                }
                stringBuffer.setLength(0);
                LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = (LiveStreamPacketizerCupertinoChunk)this.chunks.get(this.chunks.firstKey());
                int n3 = liveStreamPacketizerCupertinoChunk.getChunkIndex();
                LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk2 = (LiveStreamPacketizerCupertinoChunk)this.chunks.get(new Integer(n3 + n2));
                stringBuffer.append("#EXTM3U\n");
                stringBuffer.append("#EXT-X-ALLOW-CACHE:" + (this.allowCaching ? "YES" : "NO") + "\n");
                stringBuffer.append("#EXT-X-TARGETDURATION:" + this.millisToSecondsDuration(this.chunkDurationTarget) + "\n");
                stringBuffer.append("#EXT-X-MEDIA-SEQUENCE:" + liveStreamPacketizerCupertinoChunk2.getChunkIndex() + "\n");
                Object object = "";
                for (int i = n2; i < n; ++i) {
                    String string4;
                    Object object2;
                    LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk3 = (LiveStreamPacketizerCupertinoChunk)this.chunks.get(new Integer(n3 + i));
                    if (string == null) {
                        object2 = liveStreamPacketizerCupertinoChunk3.getCodecInfoAudio();
                        string = this.codecInfoAudioToCodecsStr((MediaCodecInfoAudio)object2);
                    }
                    if (string2 == null) {
                        object2 = liveStreamPacketizerCupertinoChunk3.getCodecInfoVideo();
                        string2 = this.codecInfoVideoToCodecsStr((MediaCodecInfoVideo)object2);
                    }
                    if (string3 == null) {
                        object2 = liveStreamPacketizerCupertinoChunk3.getCodecInfoVideo();
                        string3 = this.codecInfoVideoToResolutionStr((MediaCodecInfoVideo)object2);
                    }
                    if ((object2 = liveStreamPacketizerCupertinoChunk3.getEncUrl()) != null && ((String)object2).length() > 0 && !((String)object).equalsIgnoreCase((String)object2)) {
                        string4 = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"".replace("{encmethod}", "AES-128");
                        String string5 = "?";
                        if (((String)object2).indexOf("?") >= 0) {
                            string5 = "&";
                        }
                        string4 = string4.replace("{enckeyurl}", (String)object2 + string5 + "{query}");
                        stringBuffer.append(string4 + "\n");
                        object = object2;
                    }
                    String string6 = string4 = this.relativePlaylistItems ? "{filename}?{query}" : "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
                    if (liveStreamPacketizerCupertinoChunk3.isNewCodecInfo()) {
                        stringBuffer.append("#EXT-X-DISCONTINUITY\n");
                    }
                    stringBuffer.append("#EXTINF:" + this.millisToSecondsDuration(liveStreamPacketizerCupertinoChunk3.getDuration()) + "," + this.titleStr + "\n");
                    stringBuffer.append(string4.replace("{filename}", "media_{index}{ext}".replace("{index}", liveStreamPacketizerCupertinoChunk3.getChunkIndex() + "")).replace("{ext}", LiveStreamPacketizerCupertinoUtils.streamModeToFileExtension(liveStreamPacketizerCupertinoChunk3.getStreamMode())) + "\n");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.updatePlaylistStr: " + exception.toString());
            exception.printStackTrace();
        }
        Object object = this.playlistLock;
        synchronized (object) {
            this.codecsStr = string2 != null && string != null ? string2 + ", " + string : (string2 != null ? string2 : (string != null ? string : null));
            this.resolutionStr = string3;
            this.playListStr = stringBuffer.toString();
        }
    }

    public String getTitleStr() {
        return this.titleStr;
    }

    public void setTitleStr(String string) {
        this.titleStr = string;
    }

    public boolean isAudioOnlyRendition() {
        return this.createAudioOnlyRendition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCalculatedBitrate() {
        Object object = this.lock;
        synchronized (object) {
            long l = this.calculatedBitrate.getBitrate();
            if (this.chunkDurationTarget > 0) {
                l += (long)this.id3FramesHeader.getSize() * 8L * 1000L / (long)this.chunkDurationTarget;
                l += (long)this.id3FramesFooter.getSize() * 8L * 1000L / (long)this.chunkDurationTarget;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCalculatedAudioBitrate() {
        Object object = this.lock;
        synchronized (object) {
            long l = this.calculatedBitrateAudio.getBitrate();
            if (this.chunkDurationTarget > 0) {
                l += (long)this.id3FramesHeaderAudio.getSize() * 8L * 1000L / (long)this.chunkDurationTarget;
                l += (long)this.id3FramesFooterAudio.getSize() * 8L * 1000L / (long)this.chunkDurationTarget;
            }
            return l;
        }
    }

    public ID3Frames getID3FramesHeader() {
        return this.id3FramesHeader;
    }

    public ID3Frames getID3FramesFooter() {
        return this.id3FramesFooter;
    }

    public ID3Frames getID3FramesHeaderAudio() {
        return this.id3FramesHeaderAudio;
    }

    public ID3Frames getID3FramesFooterAudio() {
        return this.id3FramesFooterAudio;
    }

    public ICupertinoChunkWriter getChunkWriter() {
        return this.chunkWriter;
    }

    public void setChunkWriter(ICupertinoChunkWriter iCupertinoChunkWriter) {
        this.chunkWriter = iCupertinoChunkWriter;
    }

    class BitrateCalculator {
        long bitrate = -1L;
        int count = 0;
        long totalSize = 0L;
        long totalDuration = 0L;
        int[] oldSizes = new int[3];
        long[] oldDurations = new long[3];

        BitrateCalculator() {
        }

        public void addChunk(int n, long l) {
            if (this.count >= this.oldSizes.length) {
                this.totalSize -= (long)this.oldSizes[this.count % this.oldSizes.length];
                this.totalDuration -= this.oldDurations[this.count % this.oldSizes.length];
            }
            this.totalSize += (long)n;
            this.totalDuration += l;
            this.oldSizes[this.count % this.oldSizes.length] = n;
            this.oldDurations[this.count % this.oldSizes.length] = l;
            this.bitrate = this.totalSize * 8L * 1000L / this.totalDuration;
            ++this.count;
        }

        public long getBitrate() {
            return this.bitrate;
        }
    }

    class FlushResults {
        int lastVideoIndex = -1;
        int lastAudioIndex = -1;

        FlushResults() {
        }
    }
}

