/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.drm.playready.PlayReadyEncryptionResult;
import com.wowza.wms.drm.playready.PlayReadyEncryptor;
import com.wowza.wms.drm.playready.PlayReadySampleData;
import com.wowza.wms.drm.playready.PlayReadyUtils;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentHeader;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriter;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterContext;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentWriterMedia;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingPendingFragment;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.mp3.MP3Utils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.server.PLims;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothStreamingPacketHandler {
    protected H264CodecConfigParts h264CodecConfigPart = null;
    protected SmoothStreamingMediaInfoAudio mediaInfoAudio = new SmoothStreamingMediaInfoAudio();
    protected SmoothStreamingMediaInfoVideo mediaInfoVideo = new SmoothStreamingMediaInfoVideo();
    protected SmoothStreamingPendingFragment pendingVideoFragment = null;
    protected SmoothStreamingPendingFragment pendingAudioFragment = null;
    protected List<SmoothStreamingPendingFragment> pendingVideoFragments = new ArrayList<SmoothStreamingPendingFragment>();
    protected List<SmoothStreamingPendingFragment> pendingAudioFragments = new ArrayList<SmoothStreamingPendingFragment>();
    protected boolean waitingForKeyFrame = true;
    protected long lastAdjAudioTimecode = -1L;
    protected long lastAdjVideoTimecode = -1L;
    protected boolean lastAdjAudioTimecodeWarning = true;
    protected boolean lastAdjVideoTimecodeWarning = true;
    protected int lastAdjAudioTimecodeBackwardsCount = 0;
    protected int lastAdjVideoTimecodeBackwardsCount = 0;
    protected boolean videoExists = false;
    protected boolean videoHitKeyFrame = false;
    protected int videoMinDurationSkipBreakCount = 0;
    protected LiveStreamPacketizerSmoothStreaming smoothStreamingPacketizer = null;
    protected long ftc = -1L;
    protected long mtc = Long.MAX_VALUE;
    protected boolean rtc = true;
    protected PlayReadyEncryptor playReadyEncryptorAudio = null;
    protected PlayReadyEncryptor playReadyEncryptorVideo = null;
    protected long[] fragmentDurations = new long[3];
    protected int fragmentDurationIndex = 0;

    public SmoothStreamingPacketHandler() {
        try {
            int n;
            Object[] objectArray;
            String[] stringArray;
            Object object;
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            String string3 = (String)MediaStreamBase.sinfo.get("slp");
            int n2 = -2;
            String[] stringArray2 = string2.split("[|]");
            String string4 = "p" + string3 + "=";
            for (int i = 0; i < stringArray2.length; ++i) {
                object = stringArray2[i];
                if (!((String)object).startsWith(string4)) continue;
                object = ((String)object).substring(string4.length());
                stringArray = ((String)object).split("[,]");
                for (int j = 0; j < stringArray.length; ++j) {
                    objectArray = stringArray[j].split(":");
                    if (!objectArray[0].equals("s")) continue;
                    n2 = Integer.parseInt((String)objectArray[1]);
                }
            }
            BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
            object = bigInteger2.toByteArray();
            stringArray = (String[])MediaStreamBase.sinfo.get("r1");
            byte[] byArray = stringArray.toByteArray();
            objectArray = new byte[ModuleConnect.lc.length];
            byte[] byArray2 = new byte[ModuleConnect.lc.length];
            System.arraycopy(ModuleConnect.lc, 0, objectArray, 0, ModuleConnect.lc.length);
            System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
            for (n = 0; n < byArray2.length; ++n) {
                int n3 = n;
                objectArray[n3] = (byte)(objectArray[n3] ^ byArray[(n + 11) % byArray.length]);
            }
            this.mtc = PLims.getInstance().check((long)n2, objectArray);
            for (n = 0; n < byArray2.length; ++n) {
                int n4 = n;
                byArray2[n4] = (byte)(byArray2[n4] ^ byArray[(n + 11) % byArray.length]);
                int n5 = n;
                byArray2[n5] = (byte)(byArray2[n5] ^ object[(n + 5) % ((Object)object).length]);
            }
            for (n = 0; n < ModuleConnect.lc.length; ++n) {
                if (objectArray[n] == byArray2[n]) continue;
                WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)14)));
                System.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(LiveStreamPacketizerSmoothStreaming liveStreamPacketizerSmoothStreaming) {
        this.smoothStreamingPacketizer = liveStreamPacketizerSmoothStreaming;
    }

    public void startStream(IMediaStream iMediaStream) {
        this.doStreamReset();
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.startStream[" + this.smoothStreamingPacketizer.getContextStr() + "]");
    }

    public void resetStream(IMediaStream iMediaStream) {
        this.lastAdjAudioTimecode = -1L;
        this.lastAdjVideoTimecode = -1L;
        this.lastAdjAudioTimecodeWarning = true;
        this.lastAdjVideoTimecodeWarning = true;
        this.lastAdjAudioTimecodeBackwardsCount = 0;
        this.lastAdjVideoTimecodeBackwardsCount = 0;
        this.videoMinDurationSkipBreakCount = 0;
    }

    private void doStreamReset() {
        this.waitingForKeyFrame = true;
        this.lastAdjAudioTimecode = -1L;
        this.lastAdjVideoTimecode = -1L;
        this.lastAdjAudioTimecodeWarning = true;
        this.lastAdjVideoTimecodeWarning = true;
        this.lastAdjAudioTimecodeBackwardsCount = 0;
        this.lastAdjVideoTimecodeBackwardsCount = 0;
        this.videoMinDurationSkipBreakCount = 0;
        this.videoExists = false;
        this.videoHitKeyFrame = false;
        this.fragmentDurations = new long[3];
        this.fragmentDurationIndex = 0;
        this.ftc = -1L;
        this.pendingAudioFragment = null;
        this.pendingVideoFragment = null;
        this.pendingAudioFragments.clear();
        this.pendingVideoFragments.clear();
        this.smoothStreamingPacketizer.clearFragmentAudio();
        this.smoothStreamingPacketizer.clearFragmentVideo();
    }

    public long recalculateDuration(SmoothStreamingPendingFragment smoothStreamingPendingFragment, long l) {
        Iterator<SmoothStreamingMediaPacket> iterator = smoothStreamingPendingFragment.frames.iterator();
        long l2 = 0L;
        long l3 = -1L;
        long l4 = 0L;
        while (iterator.hasNext()) {
            SmoothStreamingMediaPacket smoothStreamingMediaPacket = iterator.next();
            long l5 = smoothStreamingMediaPacket.getTimecode();
            if (l3 >= 0L) {
                long l6 = l5 - l3;
                if (l6 < 0L) {
                    l6 = l4;
                } else {
                    l4 = l6;
                }
                l2 += l6;
            }
            l3 = l5;
        }
        if (l3 >= 0L) {
            long l7 = l - l3;
            if (l7 < 0L) {
                l7 = l4;
            }
            l2 += l7;
        }
        return l2;
    }

    public void handlePacket(long l, IMediaStream iMediaStream, AMFPacket aMFPacket) {
        block75: {
            int n = aMFPacket.getType();
            int n2 = aMFPacket.getSize();
            long l2 = aMFPacket.getAbsTimecode();
            long l3 = l2 * 10000L;
            try {
                if (n == 8) {
                    Object object;
                    Object object2;
                    if (n2 < 2) break block75;
                    byte[] byArray = aMFPacket.getData();
                    int n3 = byArray[0] & 0xFF;
                    int n4 = byArray[1] & 0xFF;
                    int n5 = FLVUtils.getAudioCodec((int)n3);
                    if (n5 != 10 && n5 != 2) break block75;
                    if (n5 == 10 && n4 != 1) {
                        if (n4 == 0) {
                            AACFrame aACFrame = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)2);
                            if (aACFrame != null) {
                                this.mediaInfoAudio.setAudioSamplingRate(aACFrame.getSampleRate());
                                this.mediaInfoAudio.setAudioChannels(aACFrame.getChannels());
                                this.mediaInfoAudio.setAudioBitsPerSample(16);
                                this.mediaInfoAudio.setAudioPacketSize(aACFrame.getChannels() * 2);
                            }
                            this.mediaInfoAudio.setAudioFourCC("AACL");
                            this.mediaInfoAudio.setAudioTag("255");
                            byte[] byArray2 = AACUtils.codecConfigToWaveFormatEX((byte[])byArray, (int)2, (int)(n2 - 2));
                            this.mediaInfoAudio.setAudioWaveFormatEx(byArray2);
                        }
                        break block75;
                    }
                    if (n5 == 2 && this.mediaInfoAudio.getAudioWaveFormatEx() == null) {
                        int n6;
                        if (n2 < 5) break block75;
                        byte[] byArray3 = new byte[4];
                        System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
                        object2 = MP3Utils.mp3FrameToWaveFormatEX((byte[])byArray3);
                        if (object2 != null) {
                            this.mediaInfoAudio.setAudioWaveFormatEx((byte[])object2);
                        }
                        if ((n6 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])byArray3, (MP3HeaderData)(object = new MP3HeaderData()))) != 0) {
                            MP3BufferedDecoder.decodeHeader((int)n6, (int)0, (MP3HeaderData)object);
                            int n7 = 2;
                            int n8 = MP3BufferedDecoder.frequency((MP3HeaderData)object);
                            switch (((MP3HeaderData)object).h_mode) {
                                case 0: {
                                    n7 = 2;
                                    break;
                                }
                                case 1: {
                                    n7 = 2;
                                    break;
                                }
                                case 2: {
                                    n7 = 2;
                                    break;
                                }
                                case 3: {
                                    n7 = 1;
                                }
                            }
                            this.mediaInfoAudio.setAudioSamplingRate(n8);
                            this.mediaInfoAudio.setAudioChannels(n7);
                            this.mediaInfoAudio.setAudioBitsPerSample(16);
                            this.mediaInfoAudio.setAudioPacketSize(n7 * 2);
                        }
                        this.mediaInfoAudio.setAudioFourCC("WMAP");
                        this.mediaInfoAudio.setAudioTag("85");
                    }
                    if (this.mediaInfoAudio.getAudioWaveFormatEx() == null) break block75;
                    if (this.pendingAudioFragment != null) {
                        boolean bl = false;
                        boolean bl2 = bl = this.pendingAudioFragment.startTime >= 0L && (l3 < this.pendingAudioFragment.startTime || l3 - this.pendingAudioFragment.startTime > (long)(this.smoothStreamingPacketizer.smoothFragmentTargetAudioDuration * 10000));
                        if (bl) {
                            if (this.videoHitKeyFrame) {
                                this.videoHitKeyFrame = false;
                            }
                            this.pendingAudioFragment.duration = l3 - this.pendingAudioFragment.startTime;
                            if (this.pendingAudioFragment.duration < 0L) {
                                this.pendingAudioFragment.duration = this.recalculateDuration(this.pendingAudioFragment, l3);
                            }
                            this.pendingAudioFragments.add(this.pendingAudioFragment);
                            this.smoothStreamingPacketizer.endFragmentAudio(this.pendingAudioFragment.startTime, l3);
                            object2 = this.getPendingAudioHeaders(this.pendingAudioFragments);
                            for (Long l4 : object2.keySet()) {
                                SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = (SmoothStreamingFragmentHeader)object2.get(l4);
                                this.smoothStreamingPacketizer.setFragmentAudioHeader(l4, smoothStreamingFragmentHeader, this.mediaInfoAudio);
                            }
                            object2.clear();
                            this.pendingAudioFragment = null;
                        }
                    }
                    if (this.pendingAudioFragment == null) {
                        this.pendingAudioFragment = new SmoothStreamingPendingFragment();
                        if (this.pendingAudioFragment.startTime == -1L) {
                            this.pendingAudioFragment.startTime = l3;
                        }
                        this.smoothStreamingPacketizer.startFragmentAudio(this.pendingAudioFragment.startTime);
                        if (this.smoothStreamingPacketizer.playReadyEncryptorAudio != null) {
                            this.pendingAudioFragment.playReadySampleData = new PlayReadySampleData();
                        }
                    }
                    if (this.lastAdjAudioTimecode >= 0L && l3 < this.lastAdjAudioTimecode) {
                        if (this.lastAdjAudioTimecodeWarning) {
                            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.handlePacket[" + this.smoothStreamingPacketizer.getContextStr() + "]: Timecode out of order [audio]: " + l3 + ":" + this.lastAdjAudioTimecode);
                            this.lastAdjAudioTimecodeWarning = false;
                        }
                        ++this.lastAdjAudioTimecodeBackwardsCount;
                    } else {
                        this.lastAdjAudioTimecode = l3;
                        this.lastAdjAudioTimecodeBackwardsCount = 0;
                        int n9 = n5 == 10 ? 2 : 1;
                        object2 = new SmoothStreamingMediaPacket();
                        ((SmoothStreamingMediaPacket)object2).setType(8);
                        ((SmoothStreamingMediaPacket)object2).setTimecode(l3);
                        if (this.smoothStreamingPacketizer.playReadyEncryptorAudio != null) {
                            object = PlayReadyUtils.encryptAudio((PlayReadyEncryptor)this.smoothStreamingPacketizer.playReadyEncryptorAudio, (byte[])byArray, (int)n9, (int)(n2 - n9));
                            if (object != null) {
                                ((SmoothStreamingMediaPacket)object2).setFragmentList(object.getFragments());
                                this.pendingAudioFragment.playReadySampleData.add((PlayReadyEncryptionResult)object);
                            }
                        } else {
                            ((SmoothStreamingMediaPacket)object2).getFragmentList().addPacketFragment(new RTPPacketFragment(byArray, n9, n2 - n9));
                        }
                        object = object2;
                        if (this.mtc < Long.MAX_VALUE) {
                            if (this.ftc == -1L) {
                                this.ftc = l;
                            } else if (l - this.ftc > this.mtc) {
                                object = null;
                                if (this.rtc) {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                                    this.rtc = false;
                                }
                            }
                        }
                        this.smoothStreamingPacketizer.addFragmentAudioMediaPacket(this.pendingAudioFragment.startTime, (SmoothStreamingMediaPacket)object);
                        this.pendingAudioFragment.frames.add((SmoothStreamingMediaPacket)object2);
                        this.pendingAudioFragment.size += ((SmoothStreamingMediaPacket)object2).getSize();
                    }
                    break block75;
                }
                if (n == 9 && n2 >= 5) {
                    byte[] byArray = aMFPacket.getData();
                    int n10 = byArray[0] & 0xFF;
                    int n11 = byArray[1] & 0xFF;
                    int n12 = FLVUtils.getVideoCodec((int)n10);
                    if (n12 == 7) {
                        if (n12 == 7 && n11 != 1) {
                            if (n11 == 0) {
                                this.h264CodecConfigPart = H264Utils.breakApartAVCC((byte[])byArray, (int)5, (int)(n2 - 5));
                                H264CodecConfigInfo h264CodecConfigInfo = H264Utils.decodeAVCC((byte[])byArray, (int)5);
                                if (this.h264CodecConfigPart != null) {
                                    byte[] byArray4 = H264Utils.configPartsToSmoothPrivateData((H264CodecConfigParts)this.h264CodecConfigPart);
                                    this.mediaInfoVideo.setVideoCodecPrivateData(byArray4);
                                }
                                this.mediaInfoVideo.setVideoWidth(h264CodecConfigInfo.width);
                                this.mediaInfoVideo.setVideoHeight(h264CodecConfigInfo.height);
                                this.mediaInfoVideo.setDisplayWidth(h264CodecConfigInfo.displayWidth);
                                this.mediaInfoVideo.setDisplayHeight(h264CodecConfigInfo.displayHeight);
                                this.mediaInfoVideo.setVideoFourCC("H264");
                            }
                        } else {
                            int n13 = FLVUtils.getFrameType((int)n10);
                            int n14 = 0;
                            this.videoExists = true;
                            if (n12 == 7 && n2 >= 5) {
                                n14 = BufferUtils.byteArrayToInt((byte[])byArray, (int)2, (int)3) * 10000;
                            }
                            if (!this.waitingForKeyFrame || n13 == 1) {
                                int n15;
                                AMFPacket aMFPacket2;
                                this.videoHitKeyFrame = n13 == 1;
                                this.waitingForKeyFrame = false;
                                if (this.h264CodecConfigPart == null && (aMFPacket2 = iMediaStream.getVideoCodecConfigPacket(l2)) != null) {
                                    byte[] byArray5 = aMFPacket2.getData();
                                    n15 = aMFPacket2.getSize();
                                    this.h264CodecConfigPart = H264Utils.breakApartAVCC((byte[])byArray5, (int)5, (int)(n15 - 5));
                                }
                                if (this.h264CodecConfigPart != null) {
                                    if (this.pendingVideoFragment != null) {
                                        long l5;
                                        boolean bl;
                                        boolean bl3 = bl = n13 == 1 && this.pendingVideoFragment.frames.size() > 0;
                                        if (bl && this.smoothStreamingPacketizer.smoothMinimumVideoFragmentDuration > 0 && (l5 = l3 - this.pendingVideoFragment.startTime) > 0L && l5 < (long)(this.smoothStreamingPacketizer.smoothMinimumVideoFragmentDuration * 10000)) {
                                            ++this.videoMinDurationSkipBreakCount;
                                            if (this.videoMinDurationSkipBreakCount < 4) {
                                                bl = false;
                                            }
                                        }
                                        if (bl) {
                                            this.pendingVideoFragment.duration = l3 - this.pendingVideoFragment.startTime;
                                            if (this.pendingVideoFragment.duration < 0L) {
                                                this.pendingVideoFragment.duration = this.recalculateDuration(this.pendingVideoFragment, l3);
                                            }
                                            this.pendingVideoFragments.add(this.pendingVideoFragment);
                                            this.smoothStreamingPacketizer.endFragmentVideo(this.pendingVideoFragment.startTime, l3);
                                            this.videoMinDurationSkipBreakCount = 0;
                                            this.fragmentDurations[this.fragmentDurationIndex % this.fragmentDurations.length] = this.pendingVideoFragment.duration;
                                            ++this.fragmentDurationIndex;
                                            if (this.fragmentDurationIndex == this.fragmentDurations.length) {
                                                String string = "";
                                                n15 = 1;
                                                for (int i = 0; i < this.fragmentDurations.length; ++i) {
                                                    double d;
                                                    if (i > 0) {
                                                        string = string + ",";
                                                    }
                                                    if ((d = (double)(this.fragmentDurations[this.fragmentDurationIndex % this.fragmentDurations.length] / 1000000L) / 10.0) >= 4.1) {
                                                        n15 = 0;
                                                    }
                                                    string = string + d + "";
                                                }
                                                if (n15 != 0) {
                                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.handlePacket[" + this.smoothStreamingPacketizer.getContextStr() + "]: Fragment durations: [" + string + "]");
                                                } else {
                                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.handlePacket[" + this.smoothStreamingPacketizer.getContextStr() + "]: Fragment duration greater than suggested range of 1-4 seconds. Adjust keyframe interval accordingly: Fragment durations: [" + string + "]");
                                                }
                                            }
                                            Map<Long, SmoothStreamingFragmentHeader> map = this.getPendingVideoHeaders(this.pendingVideoFragments);
                                            for (Long l6 : map.keySet()) {
                                                SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = map.get(l6);
                                                this.smoothStreamingPacketizer.setFragmentVideoHeader(l6, smoothStreamingFragmentHeader, this.mediaInfoVideo);
                                            }
                                            map.clear();
                                            this.pendingVideoFragment = null;
                                        }
                                    }
                                    if (this.pendingVideoFragment == null) {
                                        this.pendingVideoFragment = new SmoothStreamingPendingFragment();
                                        if (this.pendingVideoFragment.startTime == -1L) {
                                            this.pendingVideoFragment.startTime = l3;
                                        }
                                        this.smoothStreamingPacketizer.startFragmentVideo(l3);
                                        if (this.smoothStreamingPacketizer.playReadyEncryptorVideo != null) {
                                            this.pendingVideoFragment.playReadySampleData = new PlayReadySampleData();
                                        }
                                    }
                                    if (this.lastAdjVideoTimecode >= 0L && l3 < this.lastAdjVideoTimecode) {
                                        if (this.lastAdjVideoTimecodeWarning) {
                                            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.handlePacket[" + this.smoothStreamingPacketizer.getContextStr() + "]: Timecode out of order [video]: " + l3 + ":" + this.lastAdjVideoTimecode);
                                            this.lastAdjVideoTimecodeWarning = false;
                                        }
                                        ++this.lastAdjVideoTimecodeBackwardsCount;
                                    } else {
                                        this.lastAdjVideoTimecode = l3;
                                        this.lastAdjVideoTimecodeBackwardsCount = 0;
                                        RTPPacketFragmentList rTPPacketFragmentList = null;
                                        if (this.smoothStreamingPacketizer.smoothStreamingMediaMajorVersion >= 2) {
                                            if (this.smoothStreamingPacketizer.playReadyEncryptorVideo != null) {
                                                PlayReadyEncryptionResult playReadyEncryptionResult = PlayReadyUtils.encryptVideo((PlayReadyEncryptor)this.smoothStreamingPacketizer.playReadyEncryptorVideo, (byte[])byArray, (int)5, (int)(n2 - 5), (int)this.smoothStreamingPacketizer.smoothPlayReadyH264ClearSize);
                                                if (playReadyEncryptionResult != null) {
                                                    rTPPacketFragmentList = playReadyEncryptionResult.getFragments();
                                                    this.pendingVideoFragment.playReadySampleData.add(playReadyEncryptionResult);
                                                }
                                            } else {
                                                rTPPacketFragmentList = new RTPPacketFragmentList();
                                                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, 5, n2 - 5);
                                                rTPPacketFragmentList.addPacketFragment(rTPPacketFragment);
                                            }
                                        } else {
                                            rTPPacketFragmentList = H264Utils.breakH264PacketIntoDelimitedNALUnits((byte[])byArray, (int)5, (int)(n2 - 5), (int)n13, (H264CodecConfigParts)this.h264CodecConfigPart);
                                        }
                                        if (rTPPacketFragmentList != null) {
                                            SmoothStreamingMediaPacket smoothStreamingMediaPacket = new SmoothStreamingMediaPacket();
                                            smoothStreamingMediaPacket.setType(9);
                                            smoothStreamingMediaPacket.getFragmentList().addPacketFragments(rTPPacketFragmentList);
                                            smoothStreamingMediaPacket.setTimecode(l3);
                                            smoothStreamingMediaPacket.setCTTS(n14);
                                            smoothStreamingMediaPacket.setFrameType(n13);
                                            SmoothStreamingMediaPacket smoothStreamingMediaPacket2 = smoothStreamingMediaPacket;
                                            if (this.mtc < Long.MAX_VALUE) {
                                                if (this.ftc == -1L) {
                                                    this.ftc = l;
                                                } else if (l - this.ftc > this.mtc) {
                                                    smoothStreamingMediaPacket2 = null;
                                                    if (this.rtc) {
                                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)121)));
                                                        this.rtc = false;
                                                    }
                                                }
                                            }
                                            this.smoothStreamingPacketizer.addFragmentVideoMediaPacket(this.pendingVideoFragment.startTime, smoothStreamingMediaPacket2);
                                            this.pendingVideoFragment.frames.add(smoothStreamingMediaPacket);
                                            this.pendingVideoFragment.size += rTPPacketFragmentList.size();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.handlePacket: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (this.lastAdjAudioTimecodeBackwardsCount > 10 || this.lastAdjVideoTimecodeBackwardsCount > 10) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.resetStream[" + this.smoothStreamingPacketizer.getContextStr() + "][" + this.lastAdjAudioTimecodeBackwardsCount + ":" + this.lastAdjVideoTimecodeBackwardsCount + "]: Timecodes jumped back in time.");
            this.lastAdjAudioTimecodeBackwardsCount = 0;
            this.lastAdjVideoTimecodeBackwardsCount = 0;
            this.resetStream(iMediaStream);
        }
    }

    private int calculateBitrate(List<SmoothStreamingPendingFragment> list) {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        for (SmoothStreamingPendingFragment smoothStreamingPendingFragment : list) {
            l += smoothStreamingPendingFragment.duration;
            l2 += (long)smoothStreamingPendingFragment.size;
        }
        if (l > 0L) {
            n = (int)(l2 * 8L * 10000000L / l);
        }
        return n;
    }

    private Map<Long, SmoothStreamingFragmentHeader> getPendingVideoHeaders(List<SmoothStreamingPendingFragment> list) {
        HashMap<Long, SmoothStreamingFragmentHeader> hashMap = new HashMap<Long, SmoothStreamingFragmentHeader>();
        while (list.size() > this.smoothStreamingPacketizer.readAheadSize) {
            int n;
            if (this.mediaInfoVideo.getVideoBitrate() <= 0 && (n = this.calculateBitrate(list)) > 0) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.flushPendingVideo: Bitrate[" + this.smoothStreamingPacketizer.getContextStr() + "]: " + n);
                this.mediaInfoVideo.setVideoBitrate(n);
            }
            try {
                int n2;
                SmoothStreamingPendingFragment smoothStreamingPendingFragment = list.remove(0);
                long l = list.get((int)0).startTime;
                SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext = new SmoothStreamingFragmentWriterContext();
                SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia = new SmoothStreamingFragmentWriterMedia();
                smoothStreamingFragmentWriterMedia.packets = smoothStreamingPendingFragment.frames;
                smoothStreamingFragmentWriterMedia.lastTimecode = l;
                smoothStreamingFragmentWriterMedia.timescale = 1L;
                smoothStreamingFragmentWriterMedia.playReadySampleData = smoothStreamingPendingFragment.playReadySampleData;
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    smoothStreamingFragmentWriterMedia.playReadySampleData.flush();
                }
                smoothStreamingFragmentWriterMedia.startTimecode = smoothStreamingPendingFragment.startTime;
                smoothStreamingFragmentWriterMedia.duration = smoothStreamingPendingFragment.duration;
                smoothStreamingFragmentWriterMedia.readAheadDurations = new long[this.smoothStreamingPacketizer.readAheadSize];
                smoothStreamingFragmentWriterMedia.readAheadStartTimes = new long[this.smoothStreamingPacketizer.readAheadSize];
                for (n2 = 0; n2 < this.smoothStreamingPacketizer.readAheadSize; ++n2) {
                    smoothStreamingFragmentWriterMedia.readAheadStartTimes[n2] = list.get((int)n2).startTime;
                    smoothStreamingFragmentWriterMedia.readAheadDurations[n2] = list.get((int)n2).duration;
                }
                n2 = SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, false);
                int n3 = SmoothStreamingFragmentWriter.getMediaSize(smoothStreamingFragmentWriterMedia);
                byte[] byArray = new byte[n2];
                int n4 = 0;
                n4 = SmoothStreamingFragmentWriter.writeStartMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomMFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStartTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomTFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomTRUN(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomSDTP(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    n4 = SmoothStreamingFragmentWriter.writeAtomPlayReadyTrackUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                }
                n4 = SmoothStreamingFragmentWriter.writeAtomUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStopTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStartMDAT(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMDAT(byArray, n4, smoothStreamingFragmentWriterContext, n3);
                SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = new SmoothStreamingFragmentHeader();
                smoothStreamingFragmentHeader.setHeaderData(new RTPPacketFragment(byArray, 0, n2));
                hashMap.put(new Long(smoothStreamingPendingFragment.startTime), smoothStreamingFragmentHeader);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.getPendingVideoHeaders: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    private Map<Long, SmoothStreamingFragmentHeader> getPendingAudioHeaders(List<SmoothStreamingPendingFragment> list) {
        HashMap<Long, SmoothStreamingFragmentHeader> hashMap = new HashMap<Long, SmoothStreamingFragmentHeader>();
        while (list.size() > this.smoothStreamingPacketizer.readAheadSize) {
            int n;
            if (this.mediaInfoAudio.getAudioBitrate() <= 0 && (n = this.calculateBitrate(list)) > 0) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("LiveStreamPacketizerSmoothStreaming.flushPendingAudio: Bitrate[" + this.smoothStreamingPacketizer.getContextStr() + "]: " + n);
                this.mediaInfoAudio.setAudioBitrate(n);
            }
            try {
                int n2;
                SmoothStreamingPendingFragment smoothStreamingPendingFragment = list.remove(0);
                long l = list.get((int)0).startTime;
                SmoothStreamingFragmentWriterContext smoothStreamingFragmentWriterContext = new SmoothStreamingFragmentWriterContext();
                SmoothStreamingFragmentWriterMedia smoothStreamingFragmentWriterMedia = new SmoothStreamingFragmentWriterMedia();
                smoothStreamingFragmentWriterMedia.packets = smoothStreamingPendingFragment.frames;
                smoothStreamingFragmentWriterMedia.lastTimecode = l;
                smoothStreamingFragmentWriterMedia.timescale = 1L;
                smoothStreamingFragmentWriterMedia.playReadySampleData = smoothStreamingPendingFragment.playReadySampleData;
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    smoothStreamingFragmentWriterMedia.playReadySampleData.flush();
                }
                smoothStreamingFragmentWriterMedia.startTimecode = smoothStreamingPendingFragment.startTime;
                smoothStreamingFragmentWriterMedia.duration = smoothStreamingPendingFragment.duration;
                smoothStreamingFragmentWriterMedia.readAheadDurations = new long[this.smoothStreamingPacketizer.readAheadSize];
                smoothStreamingFragmentWriterMedia.readAheadStartTimes = new long[this.smoothStreamingPacketizer.readAheadSize];
                for (n2 = 0; n2 < this.smoothStreamingPacketizer.readAheadSize; ++n2) {
                    smoothStreamingFragmentWriterMedia.readAheadStartTimes[n2] = list.get((int)n2).startTime;
                    smoothStreamingFragmentWriterMedia.readAheadDurations[n2] = list.get((int)n2).duration;
                }
                n2 = SmoothStreamingFragmentWriter.getFragmentSize(smoothStreamingFragmentWriterMedia, false);
                int n3 = SmoothStreamingFragmentWriter.getMediaSize(smoothStreamingFragmentWriterMedia);
                byte[] byArray = new byte[n2];
                int n4 = 0;
                n4 = SmoothStreamingFragmentWriter.writeStartMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomMFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStartTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeAtomTFHD(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomTRUN(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeAtomSDTP(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                if (smoothStreamingFragmentWriterMedia.playReadySampleData != null) {
                    n4 = SmoothStreamingFragmentWriter.writeAtomPlayReadyTrackUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                }
                n4 = SmoothStreamingFragmentWriter.writeAtomUUID(byArray, n4, smoothStreamingFragmentWriterContext, smoothStreamingFragmentWriterMedia);
                n4 = SmoothStreamingFragmentWriter.writeStopTRAF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMOOF(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStartMDAT(byArray, n4, smoothStreamingFragmentWriterContext);
                n4 = SmoothStreamingFragmentWriter.writeStopMDAT(byArray, n4, smoothStreamingFragmentWriterContext, n3);
                SmoothStreamingFragmentHeader smoothStreamingFragmentHeader = new SmoothStreamingFragmentHeader();
                smoothStreamingFragmentHeader.setHeaderData(new RTPPacketFragment(byArray, 0, n2));
                hashMap.put(new Long(smoothStreamingPendingFragment.startTime), smoothStreamingFragmentHeader);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.getPendingAudioHeaders: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return hashMap;
    }
}

