/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.MemberUtils;

public class MethodUtils {
    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, string, new Object[]{object2});
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod(object, string, new Object[]{object2});
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if ((method = MethodUtils.getAccessibleMethod(clazz, string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return method.invoke(null, objectArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeStaticMethod(clazz, string, new Object[]{object});
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(clazz, string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return method.invoke(null, objectArray);
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactStaticMethod(clazz, string, new Object[]{object});
    }

    public static Object invokeExactStaticMethod(Class clazz, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        int n = objectArray.length;
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        return MethodUtils.getAccessibleMethod(clazz, string, new Class[]{clazz2});
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class clazz, String string, Class[] classArray) {
        for (Class clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                return clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                if (!Modifier.isPublic(classArray2[i].getModifiers())) continue;
                try {
                    method = classArray2[i].getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[i], string, classArray)) != null) break;
            }
            clazz = clazz.getSuperclass();
        }
        return method;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            Method method = clazz.getMethod(string, classArray);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = null;
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method2;
                if (!methodArray[i].getName().equals(string) || !ClassUtils.isAssignable(classArray, methodArray[i].getParameterTypes(), true) || (method2 = MethodUtils.getAccessibleMethod(methodArray[i])) == null || method != null && MemberUtils.compareParameterTypes(method2.getParameterTypes(), method.getParameterTypes(), classArray) >= 0) continue;
                method = method2;
            }
            if (method != null) {
                MemberUtils.setAccessibleWorkaround(method);
            }
            return method;
        }
    }
}

