/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.file;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.HTTPStreamerSanJoseIndex;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IHTTPStreamerSanJoseIndexItem;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IMediaReaderSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.List;

public class HTTPStreamerSanJoseIndexItem {
    protected String metaData = null;
    protected int width = -1;
    protected int height = -1;
    protected int displayWidth = -1;
    protected int displayHeight = -1;
    protected long duration = -1L;
    protected long bitrate = 0L;
    protected long calculatedBitrate = 0L;
    protected int avcLevel = 30;
    protected int avcProfile = 66;
    protected String streamName = null;
    protected String mimeType = "video/mp4";
    protected List<IHTTPStreamerSanJoseIndexItem> items = new ArrayList<IHTTPStreamerSanJoseIndexItem>();
    protected IMediaReaderSanJose mediaReader = null;
    protected HTTPStreamerSanJoseIndex index = null;

    public HTTPStreamerSanJoseIndexItem(HTTPStreamerSanJoseIndex hTTPStreamerSanJoseIndex) {
        this.index = hTTPStreamerSanJoseIndex;
    }

    public HTTPStreamerSanJoseIndex getIndex() {
        return this.index;
    }

    public int addIndexItem(IHTTPStreamerSanJoseIndexItem iHTTPStreamerSanJoseIndexItem) {
        this.items.add(iHTTPStreamerSanJoseIndexItem);
        return this.items.size() - 1;
    }

    public int getIndexCount() {
        return this.items.size();
    }

    public IHTTPStreamerSanJoseIndexItem getIndexItem(int n) {
        if (n < this.items.size()) {
            return this.items.get(n);
        }
        return null;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String string) {
        this.metaData = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(long l) {
        this.bitrate = l;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public void indexFile(IHTTPStreamerSession iHTTPStreamerSession) {
        if (this.mediaReader != null) {
            this.mediaReader.indexFile(this);
        }
    }

    public void close() {
        try {
            if (this.mediaReader != null) {
                this.mediaReader.close();
            }
            this.mediaReader = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error("HTTPStreamerSanJoseIndexItem.close: " + exception.toString());
        }
    }

    public void open() {
        if (this.mediaReader != null) {
            this.close();
        }
        this.mediaReader = null;
        try {
            IApplicationInstance iApplicationInstance = this.index.getAppInstance();
            String string = "mp4";
            String string2 = this.streamName;
            String string3 = "";
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string2, (String)string);
            string2 = stringArray[0];
            string = stringArray[1];
            boolean bl = string2.indexOf("://") >= 0;
            int n = string2.indexOf("?");
            if (!bl && n >= 0) {
                string3 = string2.substring(n + 1);
                string2 = string2.substring(0, n);
            }
            String string4 = string + "sanjose";
            IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)iApplicationInstance, (MediaReaderList)iApplicationInstance.getStreams().getVHost().getMediaReaders(), (String)string4);
            if (iMediaReader != null) {
                String string5 = iApplicationInstance.getStreamStoragePath();
                iMediaReader.init(iApplicationInstance, this.index.getStream(), string4, string5, string2);
                iMediaReader.open(string5, string2);
                if (iMediaReader instanceof IMediaReaderSanJose) {
                    this.mediaReader = (IMediaReaderSanJose)iMediaReader;
                } else {
                    iMediaReader.close();
                    WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error("HTTPStreamerSanJoseIndexItem.open: MediaReader is not an SanJose MediaReader: " + this.index.getStreamExt() + ":" + this.streamName);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error("HTTPStreamerSanJoseIndexItem.open: " + exception.toString());
        }
    }

    public LiveStreamPacketizerSanJoseChunk getChunk(long l) {
        LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk = null;
        try {
            int n;
            if (this.mediaReader != null && (n = (int)(l - 1L)) < this.items.size()) {
                IHTTPStreamerSanJoseIndexItem iHTTPStreamerSanJoseIndexItem = this.items.get(n);
                liveStreamPacketizerSanJoseChunk = new LiveStreamPacketizerSanJoseChunk(n);
                this.mediaReader.fillChunk(iHTTPStreamerSanJoseIndexItem, liveStreamPacketizerSanJoseChunk);
                liveStreamPacketizerSanJoseChunk.addMDATHeader();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerSanJoseIndexItem.class).error("HTTPStreamerSanJoseIndexItem.fillChunk: " + exception.toString());
        }
        return liveStreamPacketizerSanJoseChunk;
    }

    public int getAvcLevel() {
        return this.avcLevel;
    }

    public void setAvcLevel(int n) {
        this.avcLevel = n;
    }

    public int getAvcProfile() {
        return this.avcProfile;
    }

    public void setAvcProfile(int n) {
        this.avcProfile = n;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public long getCalculatedBitrate() {
        return this.calculatedBitrate;
    }

    public void setCalculatedBitrate(long l) {
        this.calculatedBitrate = l;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int n) {
        this.displayWidth = n;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setDisplayHeight(int n) {
        this.displayHeight = n;
    }
}

