/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.util;

import com.wowza.util.BufferUtils;

public class SanJoseRandomAccessBuffer {
    public static int EXTENDSIZE = 5120;
    byte[] buffer = null;
    int pos = 0;

    public SanJoseRandomAccessBuffer() {
        this.buffer = new byte[EXTENDSIZE * 2];
    }

    public SanJoseRandomAccessBuffer(int n) {
        this.buffer = new byte[n];
    }

    private void extendBuffer(int n, int n2) {
        if (n + n2 > this.buffer.length) {
            int n3 = ((n + n2) / EXTENDSIZE + 1) * EXTENDSIZE;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        this.extendBuffer(this.pos, n2);
        System.arraycopy(byArray, n, this.buffer, this.pos, n2);
        this.pos += n2;
    }

    public void write(int n) {
        this.extendBuffer(this.pos, 1);
        this.buffer[this.pos] = (byte)(n & 0xFF);
        ++this.pos;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void seek(long l) {
        this.pos = (int)l;
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void close() {
    }

    public byte[] toArray() {
        if (this.pos == this.buffer.length) {
            return this.buffer;
        }
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.buffer, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void writeAtomSize(long l) {
        try {
            byte[] byArray = new byte[4];
            long l2 = this.getFilePointer() - l;
            BufferUtils.longToByteArray((long)l2, (byte[])byArray, (int)0, (int)4);
            long l3 = this.getFilePointer();
            this.seek(l);
            this.write(byArray);
            this.seek(l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

