/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.util.QTWriterContext;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackCTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackCodecConfig;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTCO;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSC;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSZ;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterTmpItem;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class QTWriterContextTrack {
    public static final int TRACK_UNKNOWN = -1;
    public static final int TRACK_VIDEO = 0;
    public static final int TRACK_AUDIO = 1;
    public static final int TRACK_DATA = 2;
    public static final int SAMPLE_UNKNOWN = -1;
    public static final int SAMPLE_H264 = 0;
    public static final int SAMPLE_AAC = 1;
    public static final int SAMPLE_MP3 = 2;
    public static final int SAMPLE_AMF0 = 3;
    public static final int SAMPLE_AMF3 = 4;
    private int trackWidth = -1;
    private int trackHeight = -1;
    private int trackType = -1;
    private int sampleType = 0;
    private QTWriterContext context = null;
    private long timescale = 90000L;
    private long chunkCount = 0L;
    private long audESDSBufferSize = 0L;
    private long audESDSMaxRate = 0L;
    private long audESDSAvgRate = 0L;
    private long currSample = 0L;
    private long lastTimecode = -1L;
    private long duration = 0L;
    private long lastSTTSAdded = -1L;
    private List<PacketHolder> packets = new ArrayList<PacketHolder>();
    private QTWriterTmpItem trakAtomTmpItem = null;
    private long appendDuration = -1L;
    private long appendSampleCount = 0L;
    private long appendChunkCount = 0L;
    private QTWriterContextTrackCTTS ctts = null;
    private QTWriterContextTrackSTCO stco = null;
    private QTWriterContextTrackSTSC stsc = null;
    private QTWriterContextTrackSTSS stss = null;
    private QTWriterContextTrackSTSZ stsz = null;
    private QTWriterContextTrackSTTS stts = null;
    private List<QTWriterContextTrackCodecConfig> codecConfig = new ArrayList<QTWriterContextTrackCodecConfig>();

    public QTWriterContextTrack(QTWriterContext qTWriterContext, int n) {
        this.context = qTWriterContext;
        this.trackType = n;
        switch (this.trackType) {
            case 0: {
                this.sampleType = 0;
                break;
            }
            case 1: {
                this.sampleType = 1;
                break;
            }
            case 2: {
                this.sampleType = 3;
            }
        }
        this.ctts = new QTWriterContextTrackCTTS(this);
        this.stco = new QTWriterContextTrackSTCO(this);
        this.stsc = new QTWriterContextTrackSTSC(this);
        this.stss = new QTWriterContextTrackSTSS(this);
        this.stsz = new QTWriterContextTrackSTSZ(this);
        this.stts = new QTWriterContextTrackSTTS(this);
    }

    public int getCodecConfigCount() {
        return this.codecConfig.size();
    }

    public QTWriterContextTrackCodecConfig getCodecConfig(int n) {
        if (n < this.codecConfig.size()) {
            return this.codecConfig.get(n);
        }
        return null;
    }

    public void addCodecConfig(QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig) {
        this.codecConfig.add(qTWriterContextTrackCodecConfig);
    }

    public QTWriterContextTrackCTTS getCTTS() {
        return this.ctts;
    }

    public QTWriterContextTrackSTCO getSTCO() {
        return this.stco;
    }

    public QTWriterContextTrackSTSC getSTSC() {
        return this.stsc;
    }

    public QTWriterContextTrackSTSS getSTSS() {
        return this.stss;
    }

    public QTWriterContextTrackSTSZ getSTSZ() {
        return this.stsz;
    }

    public QTWriterContextTrackSTTS getSTTS() {
        return this.stts;
    }

    public boolean isVideo() {
        return this.trackType == 0;
    }

    public boolean isAudio() {
        return this.trackType == 1;
    }

    public boolean isData() {
        return this.trackType == 2;
    }

    public int getTrackType() {
        return this.trackType;
    }

    public void setTrackType(int n) {
        this.trackType = n;
    }

    public QTWriterContext getContext() {
        return this.context;
    }

    public void setContext(QTWriterContext qTWriterContext) {
        this.context = qTWriterContext;
    }

    public void addPacket(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2, boolean bl, long l) {
        this.addPacket(randomAccessFile, byArray, n, n2, bl, l, 0L);
    }

    public void addPacket(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2, boolean bl, long l, long l2) {
        this.packets.add(new PacketHolder(byArray, n, n2));
        long l3 = l * this.context.getTimescale() / this.timescale;
        this.context.addPacket(randomAccessFile, n2, l3);
        if (bl) {
            this.stss.addSyncSample(this.appendSampleCount + this.currSample + 1L);
        }
        this.stsz.addSize(n2);
        this.ctts.addOffset(l2);
        if (this.lastTimecode != -1L) {
            if (this.currSample == 1L) {
                this.stts.addDuration(l);
            } else {
                this.lastSTTSAdded = l - this.lastTimecode;
                this.stts.addDuration(this.lastSTTSAdded);
            }
        }
        this.duration = this.lastTimecode = l;
        ++this.currSample;
    }

    public void flush(RandomAccessFile randomAccessFile, boolean bl) {
        if (this.packets.size() > 0) {
            long l = 0L;
            try {
                l = randomAccessFile.getFilePointer();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error("QTWriterContextTrack.flush[" + this.context.getOutPath() + ":getFilePointer]: " + exception.toString());
            }
            this.stco.addOffset(l);
            this.stsc.addChunk(this.appendChunkCount + this.chunkCount + 1L, this.packets.size(), this.codecConfig.size());
            for (PacketHolder packetHolder : this.packets) {
                try {
                    randomAccessFile.write(packetHolder.buffer, packetHolder.offset, packetHolder.size);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error("QTWriterContextTrack.flush[" + this.context.getOutPath() + ":write]: " + exception.toString());
                }
            }
            ++this.chunkCount;
            this.packets.clear();
        }
        if (bl) {
            if (this.lastSTTSAdded != -1L) {
                this.stts.addDuration(this.lastSTTSAdded);
                this.duration += this.lastSTTSAdded;
            } else {
                this.stts.addDuration(0L);
            }
            this.ctts.flush();
            this.stco.flush();
            this.stsc.flush();
            this.stss.flush();
            this.stsz.flush();
            this.stts.flush();
        }
    }

    public long getDuration() {
        long l = this.context.getAppendDuration();
        l = l * this.timescale / this.context.getTimescale();
        return l + this.duration;
    }

    public long getDuration(long l) {
        return this.getDuration() * l / this.timescale;
    }

    public long getTimescale() {
        return this.timescale;
    }

    public void setTimescale(long l) {
        this.timescale = l;
    }

    public long millisToTimecode(long l) {
        return l * this.timescale / 1000L;
    }

    public long getTotalSampleCount() {
        return this.appendSampleCount + this.currSample;
    }

    public long getSampleCount() {
        return this.currSample;
    }

    public int getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(int n) {
        this.sampleType = n;
    }

    public long getAudESDSBufferSize() {
        return this.audESDSBufferSize;
    }

    public void setAudESDSBufferSize(long l) {
        this.audESDSBufferSize = l;
    }

    public long getAudESDSMaxRate() {
        return this.audESDSMaxRate;
    }

    public void setAudESDSMaxRate(long l) {
        this.audESDSMaxRate = l;
    }

    public long getAudESDSAvgRate() {
        return this.audESDSAvgRate;
    }

    public void setAudESDSAvgRate(long l) {
        this.audESDSAvgRate = l;
    }

    public void setWidth(int n) {
        this.trackWidth = n;
    }

    public void setHeight(int n) {
        this.trackHeight = n;
    }

    public int getWidth() {
        if (this.trackWidth >= 0) {
            return this.trackWidth;
        }
        int n = 0;
        for (QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig : this.codecConfig) {
            if (qTWriterContextTrackCodecConfig.getVideoWidth() < 0) continue;
            n = qTWriterContextTrackCodecConfig.getVideoWidth();
            break;
        }
        return n;
    }

    public int getHeight() {
        if (this.trackHeight >= 0) {
            return this.trackHeight;
        }
        int n = 0;
        for (QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig : this.codecConfig) {
            if (qTWriterContextTrackCodecConfig.getVideoWidth() < 0) continue;
            n = qTWriterContextTrackCodecConfig.getVideoHeight();
            break;
        }
        return n;
    }

    public QTWriterTmpItem getTrakAtomTmpItem() {
        return this.trakAtomTmpItem;
    }

    public void setTrakAtomTmpItem(QTWriterTmpItem qTWriterTmpItem) {
        this.trakAtomTmpItem = qTWriterTmpItem;
    }

    public long getAppendDuration() {
        return this.appendDuration;
    }

    public void setAppendDuration(long l) {
        this.appendDuration = l;
    }

    public long getAppendSampleCount() {
        return this.appendSampleCount;
    }

    public void setAppendSampleCount(long l) {
        this.appendSampleCount = l;
    }

    public long getAppendChunkCount() {
        return this.appendChunkCount;
    }

    public void setAppendChunkCount(long l) {
        this.appendChunkCount = l;
    }

    class PacketHolder {
        public byte[] buffer = null;
        public int offset = 0;
        public int size = 0;

        public PacketHolder(byte[] byArray, int n, int n2) {
            this.buffer = byArray;
            this.offset = n;
            this.size = n2;
        }
    }
}

