/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class QTWriterContextTrackCodecConfig {
    private byte[] h264CodecConfig = null;
    private byte[] aacCodecConfig = null;
    private H264CodecConfigInfo h264CodecConfigInfo = null;
    private AACFrame aacCodecConfigInfo = null;
    private byte[] bytes = null;
    private int videoHeight = -1;
    private int videoWidth = -1;
    private int audioSampleRate = 0;
    private int audioChannelCount = 2;

    public boolean isPreFormatted() {
        return this.bytes != null;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    public H264CodecConfigInfo getH264CodecConfigInfo() {
        return this.h264CodecConfigInfo;
    }

    public void setH264CodecConfig(byte[] byArray) {
        this.h264CodecConfig = byArray;
        this.h264CodecConfigInfo = byArray != null ? H264Utils.decodeAVCC((byte[])byArray) : null;
        if (this.h264CodecConfigInfo != null) {
            this.videoWidth = this.h264CodecConfigInfo.width;
            this.videoHeight = this.h264CodecConfigInfo.height;
            WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).debug("QTWriterContextTrackCodecConfig.setH264CodecConfig: " + this.h264CodecConfigInfo.toString());
        }
    }

    public void setAACCodecConfig(byte[] byArray) {
        this.aacCodecConfig = byArray;
        this.aacCodecConfigInfo = byArray != null ? AACUtils.decodeAACCodecConfig((byte[])byArray, (int)0) : null;
        if (this.aacCodecConfigInfo != null) {
            this.audioChannelCount = this.aacCodecConfigInfo.getChannels();
            this.audioSampleRate = this.aacCodecConfigInfo.getSampleRate();
            WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).debug("QTWriterContextTrackCodecConfig.setAACCodecConfig: " + this.aacCodecConfigInfo.toString());
        }
    }

    public void extractAudioDataFromMP3Frame(byte[] byArray) {
        try {
            MP3HeaderData mP3HeaderData = new MP3HeaderData();
            int n = MP3BufferedDecoder.syncHeader((byte)0, (byte[])byArray, (MP3HeaderData)mP3HeaderData);
            if (n != 0) {
                MP3BufferedDecoder.decodeHeader((int)n, (int)0, (MP3HeaderData)mP3HeaderData);
                this.audioChannelCount = mP3HeaderData.h_mode == 3 ? 1 : 2;
                this.audioSampleRate = MP3BufferedDecoder.frequency((MP3HeaderData)mP3HeaderData);
                WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).debug("QTWriterContextTrackCodecConfig.extractAudioDataFromMP3Frame: audioChannelCount:" + this.audioChannelCount + " audioSampleRate:" + this.audioSampleRate);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).error("QTWriterContextTrackCodecConfig.extractAudioDataFromMP3Frame: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public byte[] getH264CodecConfig() {
        return this.h264CodecConfig;
    }

    public byte[] getAACCodecConfig() {
        return this.aacCodecConfig;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public void setVideoHeight(int n) {
        this.videoHeight = n;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public void setVideoWidth(int n) {
        this.videoWidth = n;
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public void setAudioSampleRate(int n) {
        this.audioSampleRate = n;
    }

    public int getAudioChannelCount() {
        return this.audioChannelCount;
    }

    public void setAudioChannelCount(int n) {
        this.audioChannelCount = n;
    }
}

