/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.mediareader.h264.atom.QTAtom;
import com.wowza.wms.mediareader.h264.util.QTUtils;
import com.wowza.wms.mediawriter.h264.util.QTWriterContext;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrack;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackCTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackCodecConfig;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTCO;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSC;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSZ;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterTmpItem;
import com.wowza.wms.stream.IMediaStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.List;

public class QTWriterUtils {
    public static final int PARSETEMP_OPEN = 0;
    public static final int PARSETEMP_CLOSE = 1;
    public static final int MOOVCOPYBUFFERSIZE = 49152;

    public static void stopAtom(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, String string, long l) {
        block7: {
            try {
                long l2 = randomAccessFile.getFilePointer() - l;
                byte[] byArray = qTWriterContext.getWorkBuffer();
                if (l2 + 8L > 0xFFFFFFFFL) {
                    randomAccessFile.seek(randomAccessFile.getFilePointer() - l2 - 16L + 4L);
                    byte[] byArray2 = new byte[4];
                    randomAccessFile.read(byArray2, 0, 4);
                    String string2 = "unkn";
                    try {
                        string2 = new String(byArray2, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    randomAccessFile.seek(randomAccessFile.getFilePointer() - 8L);
                    if (string2.equals("wide") || string2.equals("skip")) {
                        BufferUtils.intToByteArray((int)1, (byte[])byArray, (int)0, (int)4);
                        System.arraycopy(string.getBytes(), 0, byArray, 4, 4);
                        BufferUtils.longToByteArray((long)(l2 + 16L), (byte[])byArray, (int)8, (int)8);
                        randomAccessFile.write(byArray, 0, 16);
                        randomAccessFile.seek(randomAccessFile.getFilePointer() + l2);
                    } else {
                        randomAccessFile.seek(randomAccessFile.getFilePointer() + l2 + 16L);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.stopAtom[" + qTWriterContext.getOutPath() + "]: Can't write long atom header. Missing 'wide' or 'skip' atom to overwrite: " + string2);
                    }
                    break block7;
                }
                randomAccessFile.seek(randomAccessFile.getFilePointer() - l2 - 8L);
                BufferUtils.intToByteArray((int)((int)(l2 + 8L)), (byte[])byArray, (int)0, (int)4);
                System.arraycopy(string.getBytes(), 0, byArray, 4, 4);
                randomAccessFile.write(byArray, 0, 8);
                randomAccessFile.seek(randomAccessFile.getFilePointer() + l2);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.stopAtom[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static long startAtom(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        long l = 0L;
        try {
            randomAccessFile.writeLong(0L);
            l = randomAccessFile.getFilePointer();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.startAtom[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
            exception.printStackTrace();
        }
        return l;
    }

    public static void writeAtomFTYP(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            String string = qTWriterContext.getMajorBrand();
            int n = qTWriterContext.getMajorBrandVersion();
            randomAccessFile.write(string.getBytes());
            randomAccessFile.write(BufferUtils.intToByteArray((int)n));
            String[] stringArray = qTWriterContext.getCompatibleBrands();
            for (int i = 0; i < stringArray.length; ++i) {
                randomAccessFile.write(stringArray[i].getBytes());
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "ftyp", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomFTYP[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomWIDE(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "wide", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomWIDE[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStartMDAT(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            qTWriterContext.pushStartLoc(l);
            qTWriterContext.setMdatLocation(randomAccessFile.getFilePointer());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStartMDAT[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAppendMDAT(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            long l = randomAccessFile.getFilePointer();
            QTAtom qTAtom = qTWriterContext.getMdatAppendAtom();
            if (qTAtom != null) {
                long l2 = l - qTAtom.getOffset();
                if (qTAtom.getHeaderSize() > 8L) {
                    randomAccessFile.seek(qTAtom.getOffset() + 8L);
                    byte[] byArray = new byte[8];
                    BufferUtils.longToByteArray((long)l2, (byte[])byArray, (int)0, (int)8);
                    randomAccessFile.write(byArray);
                } else if (l2 > 0xFFFFFFFFL) {
                    randomAccessFile.seek(qTAtom.getOffset() - 4L);
                    byte[] byArray = new byte[4];
                    randomAccessFile.read(byArray, 0, 4);
                    String string = "unkn";
                    try {
                        string = new String(byArray, "UTF-8");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    byte[] byArray2 = new byte[8];
                    randomAccessFile.seek(randomAccessFile.getFilePointer() - 8L);
                    if (string.equals("wide") || string.equals("skip")) {
                        BufferUtils.intToByteArray((int)1, (byte[])byArray2, (int)0, (int)4);
                        System.arraycopy("mdat".getBytes(), 0, byArray2, 4, 4);
                        BufferUtils.longToByteArray((long)(l2 + 8L), (byte[])byArray2, (int)8, (int)8);
                        randomAccessFile.write(byArray2, 0, 16);
                    } else {
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.stopAtom[" + qTWriterContext.getOutPath() + "]: Can't write long atom header. Missing 'wide' or 'skip' atom to overwrite: " + string);
                    }
                } else {
                    randomAccessFile.seek(qTAtom.getOffset());
                    byte[] byArray = new byte[4];
                    BufferUtils.longToByteArray((long)l2, (byte[])byArray, (int)0, (int)4);
                    randomAccessFile.write(byArray);
                }
            }
            randomAccessFile.seek(l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAppendMDAT[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStopMDAT(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "mdat", qTWriterContext.popStartLoc());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStopMDAT[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void writeStartMOOV(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            qTWriterContext.pushStartLoc(l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStartMOOV[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStopMOOV(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "moov", qTWriterContext.popStartLoc());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStopMOOV[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomMVHD(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(1);
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)3));
            long l2 = qTWriterContext.getTime();
            randomAccessFile.write(BufferUtils.longToByteArray((long)((int)l2)));
            randomAccessFile.write(BufferUtils.longToByteArray((long)((int)l2)));
            randomAccessFile.write(BufferUtils.intToByteArray((int)((int)qTWriterContext.getTimescale())));
            long l3 = qTWriterContext.getDuration();
            randomAccessFile.write(BufferUtils.longToByteArray((long)l3));
            randomAccessFile.write(BufferUtils.intToByteArray((int)65536));
            randomAccessFile.write(BufferUtils.intToByteArray((int)256, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)65536));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)65536));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0x40000000));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)qTWriterContext.getNextTrackId()));
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "mvhd", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomMVHD[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStartTRAK(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            qTWriterContext.pushStartLoc(l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStartTRAK[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStopTRAK(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "trak", qTWriterContext.popStartLoc());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStopTRAK[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomTKHD(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack, int n) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(1);
            int n2 = 1;
            if (qTWriterContextTrack.getTrackType() == 0 || qTWriterContextTrack.getTrackType() == 1) {
                n2 |= 6;
            }
            randomAccessFile.write(BufferUtils.intToByteArray((int)n2, (int)3));
            long l2 = qTWriterContext.getTime();
            randomAccessFile.write(BufferUtils.longToByteArray((long)((int)l2)));
            randomAccessFile.write(BufferUtils.longToByteArray((long)((int)l2)));
            randomAccessFile.write(BufferUtils.intToByteArray((int)(n + 1)));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.longToByteArray((long)qTWriterContextTrack.getDuration(qTWriterContext.getTimescale())));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)256, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)65536));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)65536));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0x40000000));
            if (qTWriterContextTrack.getTrackType() == 0) {
                int n3 = qTWriterContextTrack.getWidth();
                int n4 = qTWriterContextTrack.getHeight();
                randomAccessFile.write(BufferUtils.intToByteArray((int)(n3 << 16)));
                randomAccessFile.write(BufferUtils.intToByteArray((int)(n4 << 16)));
            } else {
                randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "tkhd", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomTKHD[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStartMDIA(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            qTWriterContext.pushStartLoc(l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStartMDIA[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStopMDIA(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "mdia", qTWriterContext.popStartLoc());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStopMDIA[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomMDHD(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(1);
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)3));
            long l2 = qTWriterContext.getTime();
            randomAccessFile.write(BufferUtils.longToByteArray((long)((int)l2)));
            randomAccessFile.write(BufferUtils.longToByteArray((long)((int)l2)));
            randomAccessFile.write(BufferUtils.intToByteArray((int)((int)qTWriterContextTrack.getTimescale())));
            randomAccessFile.write(BufferUtils.longToByteArray((long)qTWriterContextTrack.getDuration()));
            randomAccessFile.write(BufferUtils.intToByteArray((int)5575, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "mdhd", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomMDHD[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomMDIAHDLR(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)3));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            switch (qTWriterContextTrack.getTrackType()) {
                case 1: {
                    randomAccessFile.write("soun".getBytes());
                    break;
                }
                case 0: {
                    randomAccessFile.write("vide".getBytes());
                    break;
                }
                default: {
                    randomAccessFile.write("meta".getBytes());
                }
            }
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            randomAccessFile.write("WowzaMediaServerPro".getBytes());
            randomAccessFile.write(0);
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "hdlr", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomMDIAHDLR[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStartMINF(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            qTWriterContext.pushStartLoc(l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStartMINF[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStopMINF(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "minf", qTWriterContext.popStartLoc());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStopMINF[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomMINFSMHD(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "smhd", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomMINFSMHD[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomMINFVMHD(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 1;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "vmhd", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomMINFVMHD[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomMINFNMHD(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "nmhd", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomMINFNMHD[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomMINFDINF(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            long l2 = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            int n2 = 1;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n2));
            long l3 = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            n = 1;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "url ", l3);
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "dref", l2);
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "dinf", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomMINFDINF[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStartSTBL(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            qTWriterContext.pushStartLoc(l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStartSTBL[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeStopSTBL(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "stbl", qTWriterContext.popStartLoc());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeStopSTBL[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomSTSD(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack, int n) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n2 = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n2, (int)3));
            int n3 = qTWriterContextTrack.getCodecConfigCount();
            randomAccessFile.write(BufferUtils.intToByteArray((int)n3));
            for (int i = 0; i < n3; ++i) {
                Object object;
                QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig = qTWriterContextTrack.getCodecConfig(i);
                if (qTWriterContextTrackCodecConfig == null) continue;
                if (qTWriterContextTrackCodecConfig.isPreFormatted()) {
                    object = qTWriterContextTrackCodecConfig.getBytes();
                    randomAccessFile.write((byte[])object);
                    continue;
                }
                object = "unkn";
                long l2 = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
                randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                randomAccessFile.write(BufferUtils.intToByteArray((int)(i + 1), (int)2));
                if (qTWriterContextTrack.getSampleType() == 0) {
                    object = "avc1";
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)qTWriterContextTrackCodecConfig.getVideoWidth(), (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)qTWriterContextTrackCodecConfig.getVideoHeight(), (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0x480000));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0x480000));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)1, (int)2));
                    String string = "WowzaMediaServerPro";
                    byte[] byArray = new byte[32];
                    byArray[0] = (byte)(string.length() & 0xFF);
                    System.arraycopy(string.getBytes(), 0, byArray, 1, string.length());
                    randomAccessFile.write(byArray);
                    randomAccessFile.write(BufferUtils.intToByteArray((int)24, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)65535, (int)2));
                    long l3 = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
                    randomAccessFile.write(qTWriterContextTrackCodecConfig.getH264CodecConfig());
                    QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "avcC", l3);
                } else if (qTWriterContextTrack.getSampleType() == 1) {
                    object = "mp4a";
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)qTWriterContextTrackCodecConfig.getAudioChannelCount(), (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)16, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)qTWriterContextTrackCodecConfig.getAudioSampleRate(), (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)((int)qTWriterContextTrack.getTimescale()), (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    long l4 = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                    byte[] byArray = qTWriterContextTrackCodecConfig.getAACCodecConfig();
                    int n4 = byArray != null ? QTWriterUtils.descrLength(byArray.length) : 0;
                    QTWriterUtils.putDescr(randomAccessFile, 3, 3 + QTWriterUtils.descrLength(13 + n4) + QTWriterUtils.descrLength(1));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)(n + 1), (int)2));
                    randomAccessFile.write(0);
                    QTWriterUtils.putDescr(randomAccessFile, 4, 13 + n4);
                    randomAccessFile.write(64);
                    randomAccessFile.write(21);
                    randomAccessFile.write(BufferUtils.intToByteArray((int)((int)qTWriterContextTrack.getAudESDSBufferSize()), (int)3));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)((int)qTWriterContextTrack.getAudESDSMaxRate())));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)((int)qTWriterContextTrack.getAudESDSAvgRate())));
                    if (byArray != null) {
                        QTWriterUtils.putDescr(randomAccessFile, 5, byArray.length);
                        randomAccessFile.write(byArray);
                    }
                    QTWriterUtils.putDescr(randomAccessFile, 6, 1);
                    randomAccessFile.write(2);
                    QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "esds", l4);
                } else if (qTWriterContextTrack.getSampleType() == 2) {
                    object = ".mp3";
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)qTWriterContextTrackCodecConfig.getAudioChannelCount(), (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)qTWriterContextTrackCodecConfig.getAudioSampleRate(), (int)2));
                    randomAccessFile.write(BufferUtils.intToByteArray((int)0, (int)2));
                }
                QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, (String)object, l2);
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "stsd", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomSTSD[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    static int descrLength(int n) {
        int n2 = 1;
        while (n >> 7 * n2 > 0) {
            ++n2;
        }
        return n + 1 + n2;
    }

    static void putDescr(RandomAccessFile randomAccessFile, int n, int n2) {
        try {
            randomAccessFile.write(n);
            for (int i = QTWriterUtils.descrLength(n2) - n2 - 2; i > 0; --i) {
                randomAccessFile.write(n2 >> 7 * i | 0x80);
            }
            randomAccessFile.write(n2 & 0x7F);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.putDescr: " + exception.toString());
        }
    }

    public static void writeAtomSTTS(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            int n;
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n2 = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n2, (int)3));
            QTWriterContextTrackSTTS qTWriterContextTrackSTTS = qTWriterContextTrack.getSTTS();
            long l2 = 0L;
            byte[] byArray = null;
            int n3 = 0;
            if (qTWriterContext.isAppend() && qTWriterContextTrack.getAppendSampleCount() > 0L && qTWriterContextTrackSTTS.getAppendBlockCount() > 0) {
                long l3 = qTWriterContextTrack.getAppendDuration();
                long l4 = qTWriterContext.getAppendDuration() * qTWriterContextTrack.getTimescale() / qTWriterContext.getTimescale();
                l2 = l4 - l3;
                if (l2 < 0L) {
                    l2 = 0L;
                }
                if (l2 > 0L) {
                    int n4 = qTWriterContextTrackSTTS.getAppendBlockCount() - 1;
                    byArray = qTWriterContextTrackSTTS.getBlock(n4);
                    int n5 = byArray.length / 8;
                    long l5 = BufferUtils.byteArrayToLong((byte[])byArray, (int)((n5 - 1) * 8), (int)4);
                    long l6 = BufferUtils.byteArrayToLong((byte[])byArray, (int)((n5 - 1) * 8 + 4), (int)4);
                    if (l5 > 1L) {
                        ++n3;
                        byte[] byArray2 = new byte[byArray.length + 8];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        byArray = byArray2;
                        BufferUtils.longToByteArray((long)(l5 - 1L), (byte[])byArray, (int)((n5 - 1) * 8 + 0), (int)4);
                        BufferUtils.longToByteArray((long)1L, (byte[])byArray, (int)(n5 * 8 + 0), (int)4);
                        BufferUtils.longToByteArray((long)(l6 + l2), (byte[])byArray, (int)(n5 * 8 + 4), (int)4);
                    } else {
                        BufferUtils.longToByteArray((long)(l6 + l2), (byte[])byArray, (int)((n5 - 1) * 8 + 4), (int)4);
                    }
                }
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.durationAdjust[" + qTWriterContext.getOutPath() + "]: " + l3 + ":" + l4 + ":" + l2 + ":" + qTWriterContextTrack.getTrackType());
            }
            if ((n = qTWriterContextTrackSTTS.getItemCount() + qTWriterContextTrackSTTS.getAppendCount() + n3) > 0) {
                randomAccessFile.write(BufferUtils.intToByteArray((int)n));
                int n6 = qTWriterContextTrackSTTS.getBlockCount();
                int n7 = qTWriterContextTrackSTTS.getAppendBlockCount();
                for (int i = 0; i < n6; ++i) {
                    byte[] byArray3 = qTWriterContextTrackSTTS.getBlock(i);
                    if (byArray3 == null) continue;
                    if (byArray != null && i == n7 - 1) {
                        randomAccessFile.write(byArray);
                        continue;
                    }
                    randomAccessFile.write(byArray3);
                }
            } else {
                randomAccessFile.write(BufferUtils.intToByteArray((int)0));
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "stts", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomSTTS[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomSTSC(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            QTWriterContextTrackSTSC qTWriterContextTrackSTSC = qTWriterContextTrack.getSTSC();
            int n2 = qTWriterContextTrackSTSC.getItemCount() + qTWriterContextTrackSTSC.getAppendCount();
            randomAccessFile.write(BufferUtils.intToByteArray((int)n2));
            if (n2 > 0) {
                int n3 = qTWriterContextTrackSTSC.getBlockCount();
                for (int i = 0; i < n3; ++i) {
                    byte[] byArray = qTWriterContextTrackSTSC.getBlock(i);
                    if (byArray == null) continue;
                    randomAccessFile.write(byArray);
                }
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "stsc", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomSTSC[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomSTSZ(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            QTWriterContextTrackSTSZ qTWriterContextTrackSTSZ = qTWriterContextTrack.getSTSZ();
            if (qTWriterContextTrackSTSZ.isAppendNeedToExpand()) {
                long l2;
                QTWriterContextTrackSTTS qTWriterContextTrackSTTS = qTWriterContextTrack.getSTTS();
                long l3 = 0L;
                int n2 = (int)((long)qTWriterContextTrackSTSZ.getItemCount() + qTWriterContextTrack.getAppendSampleCount());
                randomAccessFile.write(BufferUtils.intToByteArray((int)((int)l3)));
                randomAccessFile.write(BufferUtils.intToByteArray((int)n2));
                long l4 = qTWriterContextTrackSTSZ.getAppendSampleSize();
                byte[] byArray = new byte[16384];
                for (int i = 0; i < 4096; ++i) {
                    BufferUtils.longToByteArray((long)l4, (byte[])byArray, (int)(i * 4), (int)4);
                }
                long l5 = qTWriterContextTrack.getAppendSampleCount();
                long l6 = 0L;
                do {
                    if ((l2 = l5) > 4096L) {
                        l2 = 4096L;
                    }
                    randomAccessFile.write(byArray, 0, (int)(l2 * 4L));
                    l6 += l2;
                } while ((l5 -= l2) > 0L);
                int n3 = qTWriterContextTrackSTSZ.getBlockCount();
                for (int i = 0; i < n3; ++i) {
                    byte[] byArray2 = qTWriterContextTrackSTSZ.getBlock(i);
                    if (byArray2 == null) continue;
                    randomAccessFile.write(byArray2);
                }
            } else {
                boolean bl = false;
                int n4 = qTWriterContextTrackSTSZ.getItemCount() + qTWriterContextTrackSTSZ.getAppendCount();
                long l7 = 0L;
                if (bl) {
                    l7 = qTWriterContextTrackSTSZ.getFixedSize();
                    n4 = 0;
                }
                randomAccessFile.write(BufferUtils.intToByteArray((int)((int)l7)));
                randomAccessFile.write(BufferUtils.intToByteArray((int)n4));
                if (n4 > 0) {
                    int n5 = qTWriterContextTrackSTSZ.getBlockCount();
                    for (int i = 0; i < n5; ++i) {
                        byte[] byArray = qTWriterContextTrackSTSZ.getBlock(i);
                        if (byArray == null) continue;
                        randomAccessFile.write(byArray);
                    }
                }
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "stsz", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomSTSZ[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomSTCO(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            boolean bl = true;
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            QTWriterContextTrackSTCO qTWriterContextTrackSTCO = qTWriterContextTrack.getSTCO();
            boolean bl2 = qTWriterContext.isAppend() && !qTWriterContextTrackSTCO.isAppend64Bit();
            int n2 = qTWriterContextTrackSTCO.getItemCount() + qTWriterContextTrackSTCO.getAppendCount();
            randomAccessFile.write(BufferUtils.intToByteArray((int)n2));
            if (n2 > 0) {
                int n3 = qTWriterContextTrackSTCO.getBlockCount();
                for (int i = 0; i < n3; ++i) {
                    byte[] byArray = qTWriterContextTrackSTCO.getBlock(i);
                    if (byArray == null) continue;
                    if (bl2 && i < qTWriterContextTrackSTCO.getAppendBlockCount()) {
                        int n4 = byArray.length / 4;
                        byte[] byArray2 = new byte[8 * n4];
                        for (int j = 0; j < n4; ++j) {
                            long l2 = 0L;
                            l2 = BufferUtils.byteArrayToLong((byte[])byArray, (int)(j * 4), (int)4);
                            BufferUtils.longToByteArray((long)l2, (byte[])byArray2, (int)(j * 8), (int)8);
                        }
                        randomAccessFile.write(byArray2);
                        continue;
                    }
                    randomAccessFile.write(byArray);
                }
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, bl ? "co64" : "stco", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomSTCO[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomSTSS(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
            randomAccessFile.write(0);
            int n = 0;
            randomAccessFile.write(BufferUtils.intToByteArray((int)n, (int)3));
            QTWriterContextTrackSTSS qTWriterContextTrackSTSS = qTWriterContextTrack.getSTSS();
            int n2 = qTWriterContextTrackSTSS.getItemCount() + qTWriterContextTrackSTSS.getAppendCount();
            randomAccessFile.write(BufferUtils.intToByteArray((int)n2));
            if (n2 > 0) {
                int n3 = qTWriterContextTrackSTSS.getBlockCount();
                for (int i = 0; i < n3; ++i) {
                    byte[] byArray = qTWriterContextTrackSTSS.getBlock(i);
                    if (byArray == null) continue;
                    randomAccessFile.write(byArray);
                }
            }
            QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "stss", l);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomSTSS[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeAtomCTTS(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext, QTWriterContextTrack qTWriterContextTrack) {
        try {
            QTWriterContextTrackCTTS qTWriterContextTrackCTTS = qTWriterContextTrack.getCTTS();
            if (qTWriterContextTrackCTTS.getAppendCount() != 0 || !qTWriterContextTrackCTTS.isAllZero()) {
                boolean bl;
                long l = QTWriterUtils.startAtom(randomAccessFile, qTWriterContext);
                int n = qTWriterContextTrackCTTS.getItemCount() + qTWriterContextTrackCTTS.getAppendCount();
                QTWriterContextTrackSTTS qTWriterContextTrackSTTS = qTWriterContextTrack.getSTTS();
                boolean bl2 = bl = qTWriterContext.isAppend() && qTWriterContextTrackCTTS.getAppendCount() == 0 && qTWriterContextTrack.getAppendSampleCount() > 0L;
                if (bl) {
                    ++n;
                }
                randomAccessFile.write(BufferUtils.longToByteArray((long)n));
                if (n > 0) {
                    if (bl) {
                        byte[] byArray = new byte[8];
                        BufferUtils.longToByteArray((long)qTWriterContextTrack.getAppendSampleCount(), (byte[])byArray, (int)0, (int)4);
                        randomAccessFile.write(byArray);
                    }
                    int n2 = qTWriterContextTrackCTTS.getBlockCount();
                    for (int i = 0; i < n2; ++i) {
                        byte[] byArray = qTWriterContextTrackCTTS.getBlock(i);
                        if (byArray == null) continue;
                        randomAccessFile.write(byArray);
                    }
                }
                QTWriterUtils.stopAtom(randomAccessFile, qTWriterContext, "ctts", l);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeAtomCTTS[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static boolean loadForAppendParseSTBL(int n, RandomAccessFile randomAccessFile, long l, QTWriterContextTrack qTWriterContextTrack) {
        boolean bl = true;
        try {
            QTAtom qTAtom;
            long l2 = 0L;
            while ((qTAtom = QTUtils.readAtomHeader((RandomAccessFile)randomAccessFile)) != null) {
                long l3;
                long l4;
                byte[] byArray;
                long l5;
                l2 += qTAtom.getHeaderSize();
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.durationAdjust[" + qTWriterContextTrack.getContext().getOutPath() + "]: qtAtom.moov.trak.mdia.minf.stbl: " + qTAtom.toString());
                if (qTAtom.getType().equals("stts")) {
                    if (n == 0) {
                        long l6 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l6 + 4L);
                        byte[] byArray2 = new byte[4];
                        randomAccessFile.readFully(byArray2);
                        long l7 = BufferUtils.byteArrayToLong((byte[])byArray2, (int)0, (int)4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendEntries[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l7);
                        QTWriterContextTrackSTTS qTWriterContextTrackSTTS = qTWriterContextTrack.getSTTS();
                        int n2 = 0;
                        long l8 = 0L;
                        long l9 = l7;
                        l5 = randomAccessFile.getFilePointer();
                        byArray = new byte[32768];
                        l4 = 0L;
                        do {
                            if ((l3 = l9) > 4096L) {
                                l3 = 4096L;
                            }
                            qTWriterContextTrackSTTS.insertBlock(n2, "stts", l5 + l8 * 8L, (int)(l3 * 8L));
                            randomAccessFile.readFully(byArray, 0, (int)(l3 * 8L));
                            int n3 = 0;
                            while ((long)n3 < l3) {
                                long l10 = BufferUtils.byteArrayToLong((byte[])byArray, (int)(n3 * 8), (int)4);
                                l4 += l10;
                                ++n3;
                            }
                            l8 += l3;
                            ++n2;
                        } while ((l9 -= l3) > 0L);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendSampleCount[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l4);
                        qTWriterContextTrack.setAppendSampleCount(l4);
                        qTWriterContextTrackSTTS.setAppendCount((int)l8);
                        qTWriterContextTrackSTTS.setAppendBlockCount(n2);
                        randomAccessFile.seek(l6);
                    }
                } else if (qTAtom.getType().equals("stss")) {
                    if (n == 1) {
                        long l11;
                        long l12 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l12 + 4L);
                        byte[] byArray3 = new byte[4];
                        randomAccessFile.readFully(byArray3);
                        long l13 = BufferUtils.byteArrayToLong((byte[])byArray3, (int)0, (int)4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendEntries[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l13);
                        QTWriterContextTrackSTSS qTWriterContextTrackSTSS = qTWriterContextTrack.getSTSS();
                        int n4 = 0;
                        long l14 = 0L;
                        long l15 = l13;
                        l5 = randomAccessFile.getFilePointer();
                        do {
                            if ((l11 = l15) > 4096L) {
                                l11 = 4096L;
                            }
                            qTWriterContextTrackSTSS.insertBlock(n4, "stss", l5 + l14 * 4L, (int)(l11 * 4L));
                            l14 += l11;
                            ++n4;
                        } while ((l15 -= l11) > 0L);
                        qTWriterContextTrackSTSS.setAppendCount((int)l14);
                        qTWriterContextTrackSTSS.setAppendBlockCount(n4);
                        randomAccessFile.seek(l12);
                    }
                } else if (qTAtom.getType().equals("stsd")) {
                    if (n == 0) {
                        QTAtom qTAtom2;
                        long l16 = randomAccessFile.getFilePointer();
                        int n5 = 0;
                        randomAccessFile.seek(l16 + 4L);
                        n5 += 4;
                        byte[] byArray4 = new byte[4];
                        randomAccessFile.readFully(byArray4);
                        n5 += 4;
                        int n6 = BufferUtils.byteArrayToInt((byte[])byArray4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendEntries[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + n6);
                        for (int i = 0; i < n6 && (qTAtom2 = QTUtils.readAtomHeader((RandomAccessFile)randomAccessFile)) != null; ++i) {
                            int n7;
                            n5 = (int)((long)n5 + qTAtom2.getHeaderSize());
                            if (i == 0) {
                                String string = qTAtom2.getType();
                                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.sampleType[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + string);
                                if (string.equals("avc1")) {
                                    qTWriterContextTrack.setSampleType(0);
                                } else if (string.equals("mp4a")) {
                                    qTWriterContextTrack.setSampleType(1);
                                } else if (string.equals(".mp3")) {
                                    qTWriterContextTrack.setSampleType(2);
                                } else if (string.equals("amf0")) {
                                    qTWriterContextTrack.setSampleType(3);
                                } else if (string.equals("amf3")) {
                                    qTWriterContextTrack.setSampleType(4);
                                } else {
                                    WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("writeAtomSTTS.sampleType[" + qTWriterContextTrack.getContext().getOutPath() + "]: Unrecognized sample type: " + string);
                                }
                            }
                            if ((long)(n7 = (int)qTAtom2.getDataSize()) > qTAtom.getDataSize()) break;
                            byte[] byArray5 = new byte[n7 + 8];
                            BufferUtils.longToByteArray((long)(n7 + 8), (byte[])byArray5, (int)0, (int)4);
                            System.arraycopy(qTAtom2.getType().getBytes(), 0, byArray5, 4, 4);
                            randomAccessFile.readFully(byArray5, 8, n7);
                            QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig = new QTWriterContextTrackCodecConfig();
                            qTWriterContextTrackCodecConfig.setBytes(byArray5);
                            qTWriterContextTrack.addCodecConfig(qTWriterContextTrackCodecConfig);
                            if ((long)(n5 += byArray5.length) >= qTAtom.getDataSize()) break;
                        }
                        randomAccessFile.seek(l16);
                    }
                } else if (qTAtom.getType().equals("stsz")) {
                    if (n == 1) {
                        long l17 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l17 + 4L);
                        byte[] byArray6 = new byte[4];
                        randomAccessFile.readFully(byArray6);
                        long l18 = BufferUtils.byteArrayToLong((byte[])byArray6, (int)0, (int)4);
                        long l19 = 0L;
                        if (l18 == 0L) {
                            randomAccessFile.readFully(byArray6);
                            l19 = BufferUtils.byteArrayToLong((byte[])byArray6, (int)0, (int)4);
                        }
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendEntries[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l19 + ":" + l18);
                        QTWriterContextTrackSTSZ qTWriterContextTrackSTSZ = qTWriterContextTrack.getSTSZ();
                        if (l18 != 0L) {
                            if (qTWriterContextTrackSTSZ.isAllSameSize()) {
                                if (qTWriterContextTrackSTSZ.getFixedSize() != l18) {
                                    qTWriterContextTrackSTSZ.setAppendNeedToExpand(true);
                                    qTWriterContextTrackSTSZ.setIsAllSameSize(false);
                                }
                            } else {
                                qTWriterContextTrackSTSZ.setAppendNeedToExpand(true);
                            }
                        } else {
                            long l20;
                            qTWriterContextTrackSTSZ.setIsAllSameSize(false);
                            int n8 = 0;
                            long l21 = 0L;
                            l5 = l19;
                            do {
                                if ((l20 = l5) > 4096L) {
                                    l20 = 4096L;
                                }
                                qTWriterContextTrackSTSZ.insertBlock(n8, "stsz", randomAccessFile.getFilePointer() + l21 * 4L, (int)(l20 * 4L));
                                l21 += l20;
                                ++n8;
                            } while ((l5 -= l20) > 0L);
                            qTWriterContextTrackSTSZ.setAppendCount((int)l21);
                            qTWriterContextTrackSTSZ.setAppendBlockCount(n8);
                        }
                        randomAccessFile.seek(l17);
                    }
                } else if (qTAtom.getType().equals("ctts")) {
                    if (n == 1) {
                        long l22;
                        long l23 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l23 + 4L);
                        byte[] byArray7 = new byte[4];
                        randomAccessFile.readFully(byArray7);
                        long l24 = BufferUtils.byteArrayToLong((byte[])byArray7, (int)0, (int)4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendEntries[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l24);
                        QTWriterContextTrackCTTS qTWriterContextTrackCTTS = qTWriterContextTrack.getCTTS();
                        int n9 = 0;
                        long l25 = 0L;
                        long l26 = l24;
                        l5 = randomAccessFile.getFilePointer();
                        do {
                            if ((l22 = l26) > 4096L) {
                                l22 = 4096L;
                            }
                            qTWriterContextTrackCTTS.insertBlock(n9, "ctts", l5 + l25 * 8L, (int)(l22 * 8L));
                            l25 += l22;
                            ++n9;
                        } while ((l26 -= l22) > 0L);
                        qTWriterContextTrackCTTS.setAppendCount((int)l25);
                        qTWriterContextTrackCTTS.setAppendBlockCount(n9);
                        randomAccessFile.seek(l23);
                    }
                } else if (qTAtom.getType().equals("stsc")) {
                    if (n == 0) {
                        long l27;
                        long l28 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l28 + 4L);
                        byte[] byArray8 = new byte[4];
                        randomAccessFile.readFully(byArray8);
                        long l29 = BufferUtils.byteArrayToLong((byte[])byArray8, (int)0, (int)4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendEntries[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l29);
                        QTWriterContextTrackSTSC qTWriterContextTrackSTSC = qTWriterContextTrack.getSTSC();
                        int n10 = 0;
                        long l30 = 0L;
                        long l31 = l29;
                        l5 = randomAccessFile.getFilePointer();
                        byArray = new byte[49152];
                        l4 = 0L;
                        l3 = -1L;
                        long l32 = -1L;
                        do {
                            if ((l27 = l31) > 4096L) {
                                l27 = 4096L;
                            }
                            qTWriterContextTrackSTSC.insertBlock(n10, "stsc", l5 + l30 * 12L, (int)(l27 * 12L));
                            randomAccessFile.readFully(byArray, 0, (int)(l27 * 12L));
                            int n11 = 0;
                            while ((long)n11 < l27) {
                                long l33 = BufferUtils.byteArrayToLong((byte[])byArray, (int)(n11 * 12), (int)4);
                                long l34 = BufferUtils.byteArrayToLong((byte[])byArray, (int)(n11 * 12 + 4), (int)4);
                                if (l3 != -1L) {
                                    long l35 = l33 - l3;
                                    l4 += l35 * l32;
                                }
                                l3 = l33;
                                l32 = l34;
                                ++n11;
                            }
                            l30 += l27;
                            ++n10;
                        } while ((l31 -= l27) > 0L);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.totalSamplesAccountedFor[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.lastSamplesPerChunk[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l32);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.lastFirstChunk[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l3);
                        qTWriterContextTrackSTSC.setAppendCount((int)l30);
                        qTWriterContextTrackSTSC.setAppendBlockCount(n10);
                        qTWriterContextTrackSTSC.setAppendSamplesAccountedFor(l4);
                        qTWriterContextTrackSTSC.setAppendLastSamplesPerChunk(l32);
                        qTWriterContextTrackSTSC.setAppendLastFirstChunk(l3);
                        randomAccessFile.seek(l28);
                    }
                } else if (qTAtom.getType().equals("stco") || qTAtom.getType().equals("co64")) {
                    boolean bl2 = qTAtom.getType().equals("co64");
                    if (n == 1) {
                        long l36 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l36 + 4L);
                        byte[] byArray9 = new byte[4];
                        randomAccessFile.readFully(byArray9);
                        long l37 = BufferUtils.byteArrayToLong((byte[])byArray9, (int)0, (int)4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("writeAtomSTTS.appendEntries[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + l37);
                        QTWriterContextTrackSTCO qTWriterContextTrackSTCO = qTWriterContextTrack.getSTCO();
                        int n12 = 0;
                        long l38 = 0L;
                        long l39 = l37;
                        long l40 = randomAccessFile.getFilePointer();
                        do {
                            if ((l4 = l39) > 4096L) {
                                l4 = 4096L;
                            }
                            qTWriterContextTrackSTCO.insertBlock(n12, "stsc", l40 + l38 * 8L, (int)(l4 * 8L));
                            l38 += l4;
                            ++n12;
                        } while ((l39 -= l4) > 0L);
                        qTWriterContextTrackSTCO.setAppendCount((int)l38);
                        qTWriterContextTrackSTCO.setAppendBlockCount(n12);
                        qTWriterContextTrackSTCO.setAppend64Bit(bl2);
                        randomAccessFile.seek(l36);
                    }
                }
                QTUtils.skipBytesLong((RandomAccessFile)randomAccessFile, (long)qTAtom.getDataSize());
                if ((l2 += qTAtom.getDataSize()) < l) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppendParseSTBL[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + exception.toString());
            bl = false;
        }
        return bl;
    }

    public static boolean loadForAppendParseMINF(int n, RandomAccessFile randomAccessFile, long l, QTWriterContextTrack qTWriterContextTrack) {
        boolean bl = true;
        try {
            QTAtom qTAtom;
            long l2 = 0L;
            while ((qTAtom = QTUtils.readAtomHeader((RandomAccessFile)randomAccessFile)) != null) {
                l2 += qTAtom.getHeaderSize();
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMINF[" + qTWriterContextTrack.getContext().getOutPath() + "]: qtAtom.moov.trak.mdia.minf: " + qTAtom.toString());
                if (!qTAtom.getType().equals("vmhd") && !qTAtom.getType().equals("smhd") && !qTAtom.getType().equals("nmhd") && qTAtom.getType().equals("stbl")) {
                    long l3 = randomAccessFile.getFilePointer();
                    QTWriterUtils.loadForAppendParseSTBL(n, randomAccessFile, qTAtom.getDataSize(), qTWriterContextTrack);
                    randomAccessFile.seek(l3);
                }
                QTUtils.skipBytesLong((RandomAccessFile)randomAccessFile, (long)qTAtom.getDataSize());
                if ((l2 += qTAtom.getDataSize()) < l) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppendParseMINF[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + exception.toString());
            bl = false;
        }
        return bl;
    }

    public static boolean loadForAppendParseMDIA(int n, RandomAccessFile randomAccessFile, long l, QTWriterContextTrack qTWriterContextTrack) {
        boolean bl = true;
        try {
            QTAtom qTAtom;
            long l2 = 0L;
            while ((qTAtom = QTUtils.readAtomHeader((RandomAccessFile)randomAccessFile)) != null) {
                byte[] byArray;
                long l3;
                l2 += qTAtom.getHeaderSize();
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMDIA[" + qTWriterContextTrack.getContext().getOutPath() + "]: qtAtom.moov.trak.mdia: " + qTAtom.toString());
                if (qTAtom.getType().equals("mdhd")) {
                    if (n == 0) {
                        l3 = randomAccessFile.getFilePointer();
                        byArray = new byte[8];
                        long l4 = 0L;
                        long l5 = 0L;
                        int n2 = randomAccessFile.read() & 0xFF;
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMDIA[" + qTWriterContextTrack.getContext().getOutPath() + "]: version: " + n2);
                        if (n2 == 0) {
                            randomAccessFile.seek(l3 + 4L + 8L);
                            randomAccessFile.readFully(byArray, 0, 4);
                            l4 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                            randomAccessFile.readFully(byArray, 0, 4);
                            l5 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                        } else {
                            randomAccessFile.seek(l3 + 4L + 16L);
                            randomAccessFile.readFully(byArray, 0, 4);
                            l4 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                            randomAccessFile.readFully(byArray, 0, 8);
                            l5 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)8);
                        }
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMDIA[" + qTWriterContextTrack.getContext().getOutPath() + "]: timescale: " + l4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMDIA[" + qTWriterContextTrack.getContext().getOutPath() + "]: duration: " + l5);
                        qTWriterContextTrack.setTimescale(l4);
                        qTWriterContextTrack.setAppendDuration(l5);
                        randomAccessFile.seek(l3);
                    }
                } else if (qTAtom.getType().equals("hdlr")) {
                    if (n == 0) {
                        l3 = randomAccessFile.getFilePointer();
                        randomAccessFile.seek(l3 + 8L);
                        byArray = new byte[4];
                        randomAccessFile.readFully(byArray);
                        String string = BufferUtils.byteArrayToString((byte[])byArray);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMDIA[" + qTWriterContextTrack.getContext().getOutPath() + "]: Track type: " + string);
                        if (string.equals("soun")) {
                            qTWriterContextTrack.setTrackType(1);
                        } else if (string.equals("vide")) {
                            qTWriterContextTrack.setTrackType(0);
                        } else if (string.equals("meta")) {
                            qTWriterContextTrack.setTrackType(2);
                        } else {
                            WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppendParseMDIA[" + qTWriterContextTrack.getContext().getOutPath() + "]: Unrecognized track type: " + string);
                        }
                        randomAccessFile.seek(l3);
                    }
                } else if (!qTAtom.getType().equals("hdlr") && qTAtom.getType().equals("minf")) {
                    l3 = randomAccessFile.getFilePointer();
                    QTWriterUtils.loadForAppendParseMINF(n, randomAccessFile, qTAtom.getDataSize(), qTWriterContextTrack);
                    randomAccessFile.seek(l3);
                }
                QTUtils.skipBytesLong((RandomAccessFile)randomAccessFile, (long)qTAtom.getDataSize());
                if ((l2 += qTAtom.getDataSize()) < l) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppendParseMDIA[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + exception.toString());
            bl = false;
        }
        return bl;
    }

    public static boolean loadForAppendParseTRAK(int n, RandomAccessFile randomAccessFile, long l, QTWriterContextTrack qTWriterContextTrack) {
        boolean bl = true;
        try {
            QTAtom qTAtom;
            long l2 = 0L;
            while ((qTAtom = QTUtils.readAtomHeader((RandomAccessFile)randomAccessFile)) != null) {
                long l3;
                l2 += qTAtom.getHeaderSize();
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseTRAK[" + qTWriterContextTrack.getContext().getOutPath() + "]: qtAtom.moov.trak: " + qTAtom.toString());
                if (qTAtom.getType().equals("tkhd")) {
                    if (n == 0) {
                        l3 = randomAccessFile.getFilePointer();
                        int n2 = randomAccessFile.read() & 0xFF;
                        if (n2 == 0) {
                            randomAccessFile.seek(l3 + 4L + 8L + 8L + 4L + 8L + 8L + 36L);
                        } else {
                            randomAccessFile.seek(l3 + 4L + 16L + 8L + 8L + 8L + 8L + 36L);
                        }
                        byte[] byArray = new byte[4];
                        randomAccessFile.readFully(byArray);
                        long l4 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                        randomAccessFile.readFully(byArray);
                        long l5 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                        if ((l4 >>= 16) > 0L && (l5 >>= 16) > 0L) {
                            qTWriterContextTrack.setWidth((int)l4);
                            qTWriterContextTrack.setHeight((int)l5);
                        }
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseTRAK[" + qTWriterContextTrack.getContext().getOutPath() + "]: width: " + l4);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseTRAK[" + qTWriterContextTrack.getContext().getOutPath() + "]: height: " + l5);
                        randomAccessFile.seek(l3);
                    }
                } else if (qTAtom.getType().equals("mdia")) {
                    l3 = randomAccessFile.getFilePointer();
                    QTWriterUtils.loadForAppendParseMDIA(n, randomAccessFile, qTAtom.getDataSize(), qTWriterContextTrack);
                    randomAccessFile.seek(l3);
                }
                QTUtils.skipBytesLong((RandomAccessFile)randomAccessFile, (long)qTAtom.getDataSize());
                if ((l2 += qTAtom.getDataSize()) < l) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppendParseTRAK[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + exception.toString());
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean loadForAppendParseMOOV(int n, RandomAccessFile randomAccessFile, long l, QTWriterContext qTWriterContext) {
        boolean bl = true;
        try {
            QTAtom qTAtom;
            long l2 = 0L;
            do {
                long l3;
                long l4 = randomAccessFile.getFilePointer();
                qTAtom = QTUtils.readAtomHeader((RandomAccessFile)randomAccessFile);
                if (qTAtom == null) return bl;
                l2 += qTAtom.getHeaderSize();
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMOOV[" + qTWriterContext.getOutPath() + "]: qtAtom.moov: " + qTAtom.toString());
                if (qTAtom.getType().equals("mvhd")) {
                    if (n == 0) {
                        long l5 = randomAccessFile.getFilePointer();
                        byte[] byArray = new byte[8];
                        long l6 = 0L;
                        l3 = 0L;
                        int n2 = randomAccessFile.read() & 0xFF;
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMOOV[" + qTWriterContext.getOutPath() + "]: version: " + n2);
                        if (n2 == 0) {
                            randomAccessFile.seek(l5 + 4L + 8L);
                            randomAccessFile.readFully(byArray, 0, 4);
                            l6 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                            randomAccessFile.readFully(byArray, 0, 4);
                            l3 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                        } else {
                            randomAccessFile.seek(l5 + 4L + 16L);
                            randomAccessFile.readFully(byArray, 0, 4);
                            l6 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)4);
                            randomAccessFile.readFully(byArray, 0, 8);
                            l3 = BufferUtils.byteArrayToLong((byte[])byArray, (int)0, (int)8);
                        }
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMOOV[" + qTWriterContext.getOutPath() + "]: timescale: " + l6);
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMOOV[" + qTWriterContext.getOutPath() + "]: duration: " + l3);
                        qTWriterContext.setTimescale(l6);
                        qTWriterContext.setAppendDuration(l3);
                        randomAccessFile.seek(l5);
                    }
                } else if (qTAtom.getType().equals("trak") && n == 0) {
                    QTWriterContextTrack qTWriterContextTrack = new QTWriterContextTrack(qTWriterContext, -1);
                    QTWriterTmpItem qTWriterTmpItem = new QTWriterTmpItem("trak", l4, (int)qTAtom.getSize());
                    qTWriterTmpItem.setHeaderSize((int)qTAtom.getHeaderSize());
                    qTWriterContextTrack.setTrakAtomTmpItem(qTWriterTmpItem);
                    long l7 = randomAccessFile.getFilePointer();
                    QTWriterUtils.loadForAppendParseTRAK(n, randomAccessFile, qTAtom.getDataSize(), qTWriterContextTrack);
                    randomAccessFile.seek(l7);
                    if (qTWriterContextTrack.getTrackType() != -1) {
                        long l8;
                        QTWriterContextTrackSTSC qTWriterContextTrackSTSC = qTWriterContextTrack.getSTSC();
                        l3 = qTWriterContextTrack.getAppendSampleCount();
                        long l9 = l3 - qTWriterContextTrackSTSC.getAppendSamplesAccountedFor();
                        if (l9 != (l8 = l9 / qTWriterContextTrackSTSC.getAppendLastSamplesPerChunk()) * qTWriterContextTrackSTSC.getAppendLastSamplesPerChunk()) {
                            WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppendParseMOOV[" + qTWriterContext.getOutPath() + "]: WARNING: Append: The 'stsc' atom has incorrect sample count information: missingSampleCount:" + l9 + " lastChunkCount:" + l8 + " lastSamplesPerChunk:" + qTWriterContextTrackSTSC.getAppendLastSamplesPerChunk() + " totalSampleCount:" + l3 + " samplesAccountedFor:" + qTWriterContextTrackSTSC.getAppendSamplesAccountedFor());
                        }
                        long l10 = qTWriterContextTrackSTSC.getAppendLastFirstChunk() + l8 - 1L;
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppendParseMOOV[" + qTWriterContext.getOutPath() + "]: appendChunkCount: " + l10);
                        qTWriterContextTrack.setAppendChunkCount(l10);
                        qTWriterContext.addTrack(qTWriterContextTrack);
                    }
                }
                QTUtils.skipBytesLong((RandomAccessFile)randomAccessFile, (long)qTAtom.getDataSize());
            } while ((l2 += qTAtom.getDataSize()) < l);
            return bl;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppendParseMOOV[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
            return false;
        }
    }

    public static boolean flush(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, QTWriterContext qTWriterContext) {
        if (qTWriterContext.isAppend()) {
            return QTWriterUtils.flushForAppend(randomAccessFile, randomAccessFile2, qTWriterContext);
        }
        return QTWriterUtils.flushForNew(randomAccessFile, randomAccessFile2, qTWriterContext);
    }

    public static boolean flushForNew(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, QTWriterContext qTWriterContext) {
        qTWriterContext.flush(randomAccessFile);
        QTWriterUtils.writeStopMDAT(randomAccessFile, qTWriterContext);
        return true;
    }

    public static boolean flushForAppend(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, QTWriterContext qTWriterContext) {
        boolean bl = false;
        qTWriterContext.flush(randomAccessFile);
        QTWriterUtils.writeAppendMDAT(randomAccessFile, qTWriterContext);
        List<QTWriterContextTrack> list = qTWriterContext.getTracks();
        for (QTWriterContextTrack qTWriterContextTrack : list) {
            QTWriterTmpItem qTWriterTmpItem = qTWriterContextTrack.getTrakAtomTmpItem();
            if (qTWriterTmpItem == null) continue;
            try {
                randomAccessFile2.seek(qTWriterTmpItem.getOffset() + (long)qTWriterTmpItem.getHeaderSize());
                long l = qTWriterTmpItem.getSize() - qTWriterTmpItem.getHeaderSize();
                QTWriterUtils.loadForAppendParseTRAK(1, randomAccessFile2, l, qTWriterContextTrack);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.flushForAppend[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
            }
        }
        bl = true;
        return bl;
    }

    public static boolean loadForAppend(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, QTWriterContext qTWriterContext) {
        boolean bl;
        block29: {
            long l;
            bl = false;
            QTAtom qTAtom = null;
            QTAtom qTAtom2 = null;
            try {
                QTAtom qTAtom3;
                l = randomAccessFile.length();
                if (l == 0L) {
                    WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][length]: Input file is empty.");
                    break block29;
                }
                randomAccessFile.seek(0L);
                int n = 0;
                while ((qTAtom3 = QTUtils.readAtomHeader((RandomAccessFile)randomAccessFile)) != null) {
                    WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "]: qtAtom: " + qTAtom3.toString());
                    if (qTAtom3.getType().equals("mdat")) {
                        qTWriterContext.setMdatAppendOffset(qTAtom3.getOffset());
                        qTWriterContext.setMdatAppendAtom(qTAtom3);
                        qTAtom = qTAtom3;
                    } else if (qTAtom3.getType().equals("moov")) {
                        qTWriterContext.setMoovAppendOffset(qTAtom3.getOffset());
                        qTAtom2 = qTAtom3;
                    }
                    if (qTAtom3.getDataSize() < 0L) {
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][index]: Bad atom length: " + qTAtom3.getDataSize());
                    } else if (++n > 100) {
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][index]: Too many top level atom: " + n);
                    } else {
                        QTUtils.skipBytesLong((RandomAccessFile)randomAccessFile, (long)qTAtom3.getDataSize());
                        if (randomAccessFile.getFilePointer() < l) continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][index]: " + exception.toString());
            }
            if (qTAtom == null) {
                WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][index]: MDAT Atom is missing");
            } else if (qTAtom2 == null) {
                WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][index]: MOOV Atom is missing");
            } else if (qTWriterContext.isMoovAboveMDat()) {
                WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][index]: MOOV Atom is at top of file (above MDAT atom). Cannot append.");
            } else {
                l = qTAtom2.getHeaderSize() + qTAtom2.getDataSize();
                try {
                    int n;
                    randomAccessFile.seek(qTAtom2.getOffset());
                    randomAccessFile2.seek(randomAccessFile2.length());
                    byte[] byArray = new byte[8];
                    System.arraycopy("moov".getBytes(), 0, byArray, 0, 4);
                    BufferUtils.intToByteArray((int)((int)l), (byte[])byArray, (int)4, (int)4);
                    randomAccessFile2.write(byArray);
                    long l2 = randomAccessFile2.getFilePointer();
                    int n2 = 0;
                    byte[] byArray2 = new byte[49152];
                    do {
                        if ((n = (int)l) > byArray2.length) {
                            n = byArray2.length;
                        }
                        randomAccessFile.readFully(byArray2, 0, n);
                        randomAccessFile2.write(byArray2, 0, n);
                        n2 += n;
                    } while ((l -= (long)n) > 0L);
                    QTWriterTmpItem qTWriterTmpItem = new QTWriterTmpItem("moov", l2, n2);
                    qTWriterTmpItem.setHeaderSize((int)qTAtom2.getHeaderSize());
                    qTWriterContext.setMoovAtomTmpItem(qTWriterTmpItem);
                    randomAccessFile2.seek(qTWriterTmpItem.getOffset() + (long)qTWriterTmpItem.getHeaderSize());
                    QTWriterUtils.loadForAppendParseMOOV(0, randomAccessFile2, qTAtom2.getDataSize(), qTWriterContext);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][moov]: " + exception.toString());
                }
                try {
                    randomAccessFile2.seek(randomAccessFile2.length());
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][tmpf.seek]: " + exception.toString());
                }
                if (l != 0L) {
                    WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][moov]: Problem copying MOOV atom.");
                } else {
                    long l3 = qTAtom.getOffset() + qTAtom.getHeaderSize() + qTAtom.getDataSize();
                    long l4 = 0L;
                    try {
                        randomAccessFile.seek(l3);
                        randomAccessFile.setLength(l3);
                        l4 = randomAccessFile.length();
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][truncate]: " + exception.toString());
                    }
                    if (l4 != l3) {
                        WMSLoggerFactory.getLogger(QTWriterUtils.class).warn("QTWriterUtils.loadForAppend[" + qTWriterContext.getOutPath() + "][truncate]: File could not be truncated.");
                    } else {
                        qTWriterContext.setIsAppend(true);
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public static void writeNewFileHeader(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            QTWriterUtils.writeAtomFTYP(randomAccessFile, qTWriterContext);
            QTWriterUtils.writeAtomWIDE(randomAccessFile, qTWriterContext);
            QTWriterUtils.writeStartMDAT(randomAccessFile, qTWriterContext);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeNewFileHeader[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void writeMOOVAtom(RandomAccessFile randomAccessFile, QTWriterContext qTWriterContext) {
        try {
            QTWriterUtils.writeStartMOOV(randomAccessFile, qTWriterContext);
            QTWriterUtils.writeAtomMVHD(randomAccessFile, qTWriterContext);
            List<QTWriterContextTrack> list = qTWriterContext.getTracks();
            Iterator<QTWriterContextTrack> iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                QTWriterContextTrack qTWriterContextTrack = iterator.next();
                if (qTWriterContextTrack.getTotalSampleCount() <= 0L) continue;
                QTWriterUtils.writeStartTRAK(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomTKHD(randomAccessFile, qTWriterContext, qTWriterContextTrack, n);
                QTWriterUtils.writeStartMDIA(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomMDHD(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomMDIAHDLR(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeStartMINF(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                switch (qTWriterContextTrack.getTrackType()) {
                    case 1: {
                        QTWriterUtils.writeAtomMINFSMHD(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                        break;
                    }
                    case 0: {
                        QTWriterUtils.writeAtomMINFVMHD(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                        break;
                    }
                    case 2: {
                        QTWriterUtils.writeAtomMINFNMHD(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                    }
                }
                QTWriterUtils.writeAtomMINFDINF(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeStartSTBL(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomSTSD(randomAccessFile, qTWriterContext, qTWriterContextTrack, n);
                QTWriterUtils.writeAtomSTTS(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomCTTS(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomSTSC(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomSTSZ(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeAtomSTCO(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                if (qTWriterContextTrack.isVideo()) {
                    QTWriterUtils.writeAtomSTSS(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                }
                QTWriterUtils.writeStopSTBL(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeStopMINF(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeStopMDIA(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                QTWriterUtils.writeStopTRAK(randomAccessFile, qTWriterContext, qTWriterContextTrack);
                ++n;
            }
            QTWriterUtils.writeStopMOOV(randomAccessFile, qTWriterContext);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.writeMOOVAtom[" + qTWriterContext.getOutPath() + "]: " + exception.toString());
        }
    }

    public static void extractMP3CodecInfoFromPacket(byte[] byArray, QTWriterContextTrack qTWriterContextTrack) {
        try {
            int n = 1;
            byte[] byArray2 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig = new QTWriterContextTrackCodecConfig();
            qTWriterContextTrackCodecConfig.extractAudioDataFromMP3Frame(byArray2);
            qTWriterContextTrack.addCodecConfig(qTWriterContextTrackCodecConfig);
            qTWriterContextTrack.setSampleType(2);
            WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils: MP3: audioCodecStreamRate:" + qTWriterContextTrackCodecConfig.getAudioSampleRate() + " audioCodecChannels:" + qTWriterContextTrackCodecConfig.getAudioChannelCount());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.extractAACCodecInfoFromStream[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + exception.toString());
        }
    }

    public static void extractAACCodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l) {
        try {
            int n = 2;
            AMFPacket aMFPacket = iMediaStream.getAudioCodecConfigPacket(l);
            if (aMFPacket != null && aMFPacket.getSize() >= 4) {
                byte[] byArray = aMFPacket.getData();
                byte[] byArray2 = new byte[byArray.length - n];
                System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
                QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig = new QTWriterContextTrackCodecConfig();
                qTWriterContextTrackCodecConfig.setAACCodecConfig(byArray2);
                qTWriterContextTrack.addCodecConfig(qTWriterContextTrackCodecConfig);
                qTWriterContextTrack.setSampleType(1);
                WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils: AAC: audioCodecStreamRate:" + qTWriterContextTrackCodecConfig.getAudioSampleRate() + " audioCodecChannels:" + qTWriterContextTrackCodecConfig.getAudioChannelCount());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.extractAACCodecInfoFromStream[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void extractH264CodecInfoFromStream(IMediaStream iMediaStream, QTWriterContextTrack qTWriterContextTrack, long l) {
        try {
            int n = 5;
            AMFPacket aMFPacket = iMediaStream.getVideoCodecConfigPacket(l);
            if (aMFPacket != null && aMFPacket.getSize() >= 5) {
                byte[] byArray = aMFPacket.getData();
                byte[] byArray2 = new byte[byArray.length - n];
                System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
                QTWriterContextTrackCodecConfig qTWriterContextTrackCodecConfig = new QTWriterContextTrackCodecConfig();
                qTWriterContextTrackCodecConfig.setH264CodecConfig(byArray2);
                qTWriterContextTrack.addCodecConfig(qTWriterContextTrackCodecConfig);
                qTWriterContextTrack.setSampleType(0);
                H264CodecConfigInfo h264CodecConfigInfo = qTWriterContextTrackCodecConfig.getH264CodecConfigInfo();
                if (h264CodecConfigInfo != null) {
                    WMSLoggerFactory.getLogger(QTWriterUtils.class).debug("QTWriterUtils: H264: " + h264CodecConfigInfo.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterUtils.class).error("QTWriterUtils.extractH264CodecInfoFromStream[" + qTWriterContextTrack.getContext().getOutPath() + "]: " + exception.toString());
        }
    }
}

